package Hisiuin;
import java.util.*;
import java.lang.*;
import java.awt.*;

class AlmacenZ extends Hashtable{

    private int     width;
    private int     height;
    private Panel   cpanel;
    private double  weightx;
    private double  weighty;
    private int     border[] = {0, 0, 0, 0};
    private int     fill;
    private int     anchor;
    private int     ipady;
    private int     ipadx;

    public AlmacenZ(){
        super();
        cpanel = new Panel( new CardLayout() );
        this.weightx = 0.0;
        this.weighty = 0.0;
        this.fill = GridBagConstraints.NONE;
        this.anchor = GridBagConstraints.CENTER;
        this.ipadx = 0;
        this.ipady = 0;
        }



    public AlmacenZ( int width, int height ){
        super();
        cpanel = new Panel( new CardLayout() );
        this.width = width;
        this.height = height;
        this.weightx = 0.0;
        this.weighty = 0.0;
        this.fill = GridBagConstraints.NONE;
        this.anchor = GridBagConstraints.CENTER;
        this.ipadx = 0;
        this.ipady = 0;
        }



    public AlmacenZ( int z, Object w, int width, int height ){
        super();
        cpanel = new Panel( new CardLayout() );
        this.width = width;
        this.height = height;
        this.weightx = 0.0;
        this.weighty = 0.0;
        this.fill = GridBagConstraints.NONE;
        this.anchor = GridBagConstraints.CENTER;
        this.ipadx = 0;
        this.ipady = 0;
        super.put (new Integer(z),w);
        }



    public boolean remove( Integer z ){
        if (super.get(z) == null )
            return( false );

        if (cpanel != null){
            CardLayout tmp = (CardLayout)cpanel.getLayout();
            tmp.removeLayoutComponent(((Wwidget)(super.get(z))).componente());
            tmp.invalidateLayout(cpanel);
            tmp.previous(cpanel);
            }
        super.remove(z);
        return true;
        }



    public boolean setattr( Integer z, Symbol attr, int arg ){
        if (super.get(z) == null && z.intValue() != Wwidget.ALL )
            return( false );

        if ( attr == Wwidget.FILL ){
            this.fill = arg;
            }
        else if ( attr == Wwidget.LOCATION ){
            this.anchor = arg;
            }
        else if ( attr == Wwidget.WEIGHTX){
            this.weightx = (double) arg;
            }
        else if ( attr == Wwidget.WEIGHTY){
            this.weighty = (double) arg;
            }
        else if ( attr == Wwidget.TALL){
            this.ipady = arg;
            }
        else if ( attr == Wwidget.LENGTH){
            this.ipadx = arg;
            }
        else 
            return false;
        return true;
        }



    public boolean setattr( Integer z, Symbol attr, Wfont font ){
        if (super.get(z) == null && z.intValue() != Wwidget.ALL )
            return( false );
        if ( attr == Wwidget.FONT ){
            if (z.intValue() == Wwidget.ALL){
                for ( Enumeration i = elements(); i.hasMoreElements();){
                    ((Wwidget)(i.nextElement())).setFont(font);
                    }
                }
            else{
                if( super.get(z) != null )
                    ((Wwidget)(super.get(z))).setFont(font);
                else
                    return( false );
                }
            }    
        else 
            return false;
        return true;
        }



    public boolean setattr( Integer z, Symbol attr, Wcolor color ){
        if (super.get(z) == null && z.intValue() != Wwidget.ALL )
            return( false );
        if ( attr == Wwidget.BACKGROUND ){
            if (z.intValue() == Wwidget.ALL){
                for ( Enumeration i = elements(); i.hasMoreElements();){
                    ((Wwidget)(i.nextElement())).setBackground(color);
                    }
                }
            else{
                if (super.get(z) != null )
                    ((Wwidget)(super.get(z))).setBackground(color);
                else
                    return( false );
                }
            }

        else if ( attr == Wwidget.FOREGROUND ){
            if (z.intValue() == Wwidget.ALL){
                for ( Enumeration i = elements(); i.hasMoreElements();){
                    ((Wwidget)(i.nextElement())).setForeground(color);
                    }
                }
            else{
                if (super.get(z) != null )
                    ((Wwidget)(super.get(z))).setForeground(color);
                else
                    return( false );
                }
            }
        else 
            return false;
        return true;
        }



    public boolean setattr( Integer z, Symbol attr, boolean state ){
        if (super.get(z) == null && z.intValue() != Wwidget.ALL )
            return( false );
        if ( attr == Wwidget.ENABLED ){
            if (z.intValue() == Wwidget.ALL){
                for ( Enumeration i = elements(); i.hasMoreElements();){
                    ((Wwidget)(i.nextElement())).setState(state);
                    }
                }
            else{
                if (super.get(z) != null )  
                    ((Wwidget)(super.get(z))).setState(state);
                else 
                    return( false );
                }
            }
        else 
            return false;
        return true;
        }



    public boolean setattr( Integer z, Symbol attr, int arg[]){
        if (super.get(z) == null && z.intValue() != Wwidget.ALL )
            return( false );
        if ( attr == Wwidget.BORDER){            
            this.border[0] = arg[0];
            this.border[1] = arg[1];
            this.border[2] = arg[2];
            this.border[3] = arg[3];
            }        
        else 
            return false;
        return true;
        }    



    public int getheight(){
        return ( this.height );
        }



    public int getwidth(){
        return ( this.width );
        }



    public Panel reorder(GridBagConstraints pos){
        Wwidget tmp;
        pos.gridwidth     = this.width;
        pos.gridheight    = this.height;
        pos.fill          = this.fill;
        pos.anchor        = this.anchor;
        pos.weightx       = this.weightx;
        pos.weighty       = this.weighty;
        pos.ipady         = this.ipady;
        pos.ipadx         = this.ipadx;
        pos.insets        = new Insets(border[0], border[1], border[2], border[3]);
        Enumeration k = keys();
        for ( Enumeration i = elements(); i.hasMoreElements();){
            tmp = (Wwidget)i.nextElement();
            tmp.compBackground();
            tmp.compForeground();
            tmp.compFont();
            tmp.compState();
            cpanel.add(tmp.componente(),(k.nextElement()).toString());
            if (tmp instanceof Wtable)
                ((Wtable)tmp ).reorder();
            }
        cpanel.setVisible(true);
        return(cpanel);
        }



    public boolean show(Integer i){
        if (cpanel!=null){
            if ( super.get(i)!=null){
                ((CardLayout)(cpanel.getLayout())).show(cpanel, i.toString());
                }
            else
                return false;
            }
        else
            return false;
        return true;
        }



    public void hide(){
        cpanel.setVisible(false);
        }
   
    }    