function plotGeodesicClusters(shape, IP, idx)
[vertex, faces] = read_off(shape);

cmap = [1.0 0.0 0.0;
        0.0 1.0 0.0;
        0.0 0.0 1.0;
        0.0 1.0 1.0;
        1.0 1.0 0.0;
        1.0 0.0 1.0;
        0.8 0.8 0.8];

scale = 0.01;
figure('Color', 'white');
hold on;

trisurf(faces', vertex(1,:), vertex(2,:), vertex(3,:), 7, 'SpecularExponent', 100);

[X,Y,Z] = sphere(40);

for i = 1:length(IP)
       if idx(i)~=0
                surf(X*scale + vertex(1,IP(i)), Y*scale + vertex(2, IP(i)), Z*scale + vertex(3, IP(i)), 'CData', repmat(idx(i), size(X)));
       end
       
end

axis image, axis off, shading flat;
view(3)
camlight head;
lighting phong;
colormap(cmap);