shape = 'NR18.off';
ip_file = 'NR18_IPH1.mat';
distance_file = 'NR18_D.mat';

[vertex, faces] = read_off(shape);
B = load(ip_file);
IP = double(B.IP);

C = load(distance_file);
Y = smacof(C.D, 2);
[cent, w, idx] = adaptiveClustering(Y, 0.1, 0.2, 6, 10, 0);

plotMDS(Y);
plotGeodesicClusters(shape, IP, idx);
