

// Implements the Map data structure, which maps block ids to lztrie nodes

#ifndef NODEMAPINCLUDED
#define NODEMAPINCLUDED

#include "basics.h"
#include "lztrie.h"

typedef struct snodemap
   { uint n;		// # of cells
     uint nbits;        // bits per cell
     uint *map;         // mapping
   } *nodemap;

        // creates a nodemap structure from a mapping array, not owning it
        // n is number of blocks
        // max is the number of trie nodes
nodemap createNodemap (uint *map, uint n, uint max);
	// frees revtrie structure, including the owned data
void destroyNodemap (nodemap M);
	// mapping
trieNode mapto (nodemap M, uint id);
	// saves nodemap to file f
void saveNodemap (nodemap M, FILE *f);
	// loads nodemap from f
nodemap loadNodemap (FILE *f);

#endif
