#define TypeByte unsigned char
#define NEWLINE '\n'

extern char *progname;
extern int numk;  /* numero de errores */


typedef struct pnode {
	TypeByte *pattern;
	int aclen;                /* accum lengths of Ps[0..i] */
	int len;                  /* length of Ps[i] */
	struct pnode *next_pattern;
} TypePatternNode;

typedef struct plist {
	int count;  	// int j;   /* number of subpatterns */
	int lmin;
	int lmax;
      int k;                     /* k/j */
	TypePatternNode *last_pattern;
	TypePatternNode *next_pattern;
} TypePatternList;
extern TypePatternList PatternList;

/* List of compressed files */
typedef struct fnode {
	char *file;
	struct fnode *next_file;
} TypeFileNode;
typedef struct  flist {
	int count;
	TypeFileNode *next_file;
	TypeFileNode *last_file;
} TypeFileList;
extern TypeFileList FileList;

/* Global Options */
extern int optContextBefore; /* Number of context lines before a match */
extern int optContextAfter;  /* Number of context lines after a match */
extern int optPrintFilename; /* Prints name of matched file */
extern int optBinaryFiles;   /* How to manipulate binary files */
extern int optByteOffset;    /* Print the byte offset */
extern int optCountMatches;  /* Only count the matches */
extern int optIgnoreCase;    /* Ignore case */
extern int optListFiles; /* List files with match (=1), without match (=-1).*/
extern int optStopAfter; /* Stop after optStop After matchs (0 ==> no stop) */
extern int optLineNumber; /* Prints line number of each matched line */
extern int optOnlyMatching; /* Prints only matching part of the line */
extern int optSilent;        /* Supress normal output */
extern int optSupressErrors; /* Supress error messages */

/* Global Indicators, Obtained from options */
extern int indPrintMatches; /* Prints  Matched lines */
extern int indLinePrefix; /* Prints a Prefix before each printed line */

/* Values for optBinaryFiles */
#define binaryFilesBinary  0 /* Only prints if file match or not */
#define binaryFilesWithoutMatch 1 /* Asume binary files never matches */
#define binaryFilesText 2 /* Manipulate binary files as text */

/* Parameters for current  search */
extern int fdSearch;  /* File Descriptor of ZFILE to search */
extern char *filenameSearch; /* Filename of file to search */


