#include "format.h"
#include "lzgrep.h"
#include "util.h"
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>   
#include <errno.h>

#define DE_BUFSIZE 0x8000
unsigned char de_buf[DE_BUFSIZE];
unsigned short tab_prefix[1<<BITS];
unsigned char tab_suffix[1<<BITS];
unsigned char *stackp;
#define de_stack  ((unsigned char *) &de_buf[DE_BUFSIZE-1])
#define tab_prefixof(i) tab_prefix[i]
#define clear_tab_prefixof()    memset(tab_prefix,0,256);
#define tab_suffixof(i) tab_suffix[i]

#define input(b,o,c,n,m) { \
     register TypeByte *p = &(b)[(o)>>3]; \
     (c) = ((((long)(p[0]))|((long)(p[1])<<8)| \
     ((long)(p[2])<<16))>>((o)&0x7))&(m); \
     (o) += (n); \
   }

int rsize;
unsigned bitmask;
code_int oldcode;
unsigned char finchar;
int posbits;
int inbits;


/* Defines for third byte of header */
#define BLOCK_MASK      0x80
#define BIT_MASK        0x1f
/* Masks 0x40 and 0x20 are free.  I think 0x20 should mean that there is
   a fourth header byte (for expansion).
*/
#define INIT_BITS 9             /* initial number of bits/code */

int n_bits;				/* number of bits/code */
int maxbits = BITS;			/* user settable max # bits/code */
code_int maxcode;			/* maximum code, given n_bits */
code_int maxmaxcode = 1L << BITS;	/* should NEVER generate this code */
#ifdef COMPATIBLE		/* But wrong! */
# define MAXCODE(n_bits)	(1L << (n_bits) - 1)
#else
# define MAXCODE(n_bits)	((1L << (n_bits)) - 1)
#endif /* COMPATIBLE */

/*
 * the next two codes should not be changed lightly, as they must not
 * lie within the contiguous general code space.
 */
#define FIRST   257     /* first free entry */
#define CLEAR   256     /* table clear output code */

/*
 * block compression parameters -- after all codes are used up,
 * and compression rate changes, start over.
 */
int block_compress = BLOCK_MASK;
int clear_flg = 0;
/*
 * the next two codes should not be changed lightly, as they must not
 * lie within the contiguous general code space.
 */ 
code_int free_ent = 0;                  /* first unused entry */
int FirstFree = 0;
int Clear = 0;
int reset = 0;

int codeopen ()

   {      
        maxbits = getbyte();    /* set -b from file */
        block_compress = maxbits & BLOCK_MASK;
        maxbits &= BIT_MASK;
        maxmaxcode = 1L << maxbits;
        if(maxbits > BITS) {
           fprintf(stderr,
                    "%s: compressed with %d bits, can only handle %d bits\n",
                    filenameSearch ? filenameSearch : "stdin", maxbits, BITS);
           return 0;
        }

     rsize = insize;
     FirstFree = ((block_compress) ? FIRST : 256 );
     Clear = block_compress ? CLEAR : -1;
     maxcode = MAXCODE(n_bits = INIT_BITS);
     bitmask = (1<<n_bits)-1;
     oldcode = -1;
     finchar = 0;
     posbits = inptr<<3;
     reset = 1;
     return 1;
   }

code_int getcode() {
    register int i;
    register code_int code;
    int e,o;
    static int n=0;

    n++;
    
    resetbuf:
    if (reset) {
        e = insize-(o = (posbits>>3));
 
        for (i = 0 ; i < e ; ++i) {
            inbuf[i] = inbuf[i+o];
        }
        insize = e;
        posbits = 0;
 
        if (insize < INBUF_EXTRA) {
            if ((rsize = read(fdSearch, (char*)inbuf+insize, INBUF_SIZE)) == EOF) {
                return(-1);
            }
            insize += rsize;
        }
        inbits = ((rsize != 0) ? ((long)insize - insize%n_bits)<<3 :
                  ((long)insize<<3)-(n_bits-1));

        reset = 0;
       }
        if (inbits > posbits) {
            if (free_ent > maxcode) {
                posbits = ((posbits-1) +
                           ((n_bits<<3)-(posbits-1+(n_bits<<3))%(n_bits<<3)));
                ++n_bits;
                if (n_bits == maxbits) {
                    maxcode = maxmaxcode;
                } else {
                    maxcode = MAXCODE(n_bits);
                }
                bitmask = (1<<n_bits)-1;
                reset = 1;
                goto resetbuf;
                
            }
            input(inbuf,posbits,code,n_bits,bitmask);
 
            if (oldcode == -1) {
                if (code >= 256) perror("corrupt input.");
                finchar = (unsigned char)(oldcode=code);
                return(code);
            }  
                                                         
            if (code == Clear) {
                /*free_ent = FirstFree - 1;*/
                posbits = ((posbits-1) +
                           ((n_bits<<3)-(posbits-1+(n_bits<<3))%(n_bits<<3)));
                maxcode = MAXCODE(n_bits = INIT_BITS);
                bitmask = (1<<n_bits)-1;
                reset = 1;
                return(code);
            }
            oldcode = code;   /* Remember previous code.      */
            return(code);
        } else {
        if (rsize <= 0) return(-1);
              reset = 1; goto resetbuf;
        }
      
}
int getbuffer(char *outbuf, int size) {
    register code_int code, incode;
    register int e,o;
    register int i;
    register int outpos = 0;

    
    if (oldcode == -1) {
	    free_ent = FirstFree;
	    clear_tab_prefixof();
	    stackp = de_stack;
	   for (code = 255 ; code >= 0 ; --code)
	           tab_suffixof(code) = (unsigned char)code;
    }
    while (outpos < size) {
        i = de_stack - stackp;
	if (i > size-outpos) i = size - outpos;
	if (i > 0) {
	    memcpy(outbuf+outpos,stackp,i);
	    outpos+=i;
	    stackp+=i;
	    continue;
	}

      resetbuf:
      if (reset) {
        e = insize-(o = (posbits>>3));
 
        for (i = 0 ; i < e ; ++i) {
            inbuf[i] = inbuf[i+o];
        }
        insize = e;
        posbits = 0;
 
        if (insize < INBUF_EXTRA) {
            if ((rsize = read(fdSearch, (char*)inbuf+insize, INBUF_SIZE)) == EOF) {
                return(outpos);
            } 
            insize += rsize;
        }
        inbits = ((rsize != 0) ? ((long)insize - insize%n_bits)<<3 :
                  ((long)insize<<3)-(n_bits-1));

        reset = 0;
       }
       if (inbits > posbits) {
            if (free_ent > maxcode) {
                posbits = ((posbits-1) +
                           ((n_bits<<3)-(posbits-1+(n_bits<<3))%(n_bits<<3)));
                ++n_bits;
                if (n_bits == maxbits) {
                    maxcode = maxmaxcode;
                } else {
                    maxcode = MAXCODE(n_bits);
                }
                bitmask = (1<<n_bits)-1;
                reset = 1;
                goto resetbuf;
                
            }
            input(inbuf,posbits,code,n_bits,bitmask);
 
            if (oldcode == -1) {
                if (code >= 256) perror("corrupt input.");
                finchar = (unsigned char)(oldcode=code);
                outbuf[outpos++] = (char )finchar;
		continue;
            }  

	    stackp = de_stack;
            if (code == Clear) {
		clear_tab_prefixof();
                free_ent = FirstFree - 1;
                posbits = ((posbits-1) +
                           ((n_bits<<3)-(posbits-1+(n_bits<<3))%(n_bits<<3)));
                maxcode = MAXCODE(n_bits = INIT_BITS);
                bitmask = (1<<n_bits)-1;
                reset = 1;
		goto resetbuf;
            }
	    incode = code;
	    stackp = de_stack;
	    if (code >= free_ent) {
		    *--stackp = finchar;
		    code = oldcode;
            }
	    while (code >= 256) {
		    *--stackp = tab_suffixof(code);
		    code = tab_prefixof(code);
	    }

	    finchar = *--stackp = tab_suffixof(code);

	    if ((code=free_ent) < maxmaxcode) {
		    tab_prefixof(code) = (unsigned short)oldcode;
		    tab_suffixof(code) = finchar;
		    free_ent = code +1;
            }
            oldcode = incode;   /* Remember previous code.      */
        } else {
		if (rsize<=0) return(outpos);
		reset = 1;
	}
   }
   return(outpos);   
}
