#define size_block_array 0x10000 /* 2^16 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <strings.h>
#include "blocks.h"
#include "lzgrep.h"

TypeBlock lblock[size_block_array+1];
TypeBlock *low_blocks = lblock +1;
TypeBlock hblock[size_block_array];
TypeBlock *hi_blocks = hblock;

char outbuf[OUTBUF_SIZE+1]; /* Buffer of uncompressed data */

char oldbuf[OUTBUF_SIZE+1]; /* Buffer uncompressed data before clear */

#define CHR(x) (x & 0xFF)

void BLK_CleanState(BLK_SearchState *BLK_State) {
	  int lines;

	   BLK_State->tpos = 0;
	   BLK_State->ppos = 0;
	   BLK_State->rpos = 0;
	   BLK_State->oldbuf = oldbuf;
	   BLK_State->buf = outbuf;
	   BLK_State->count = 0;
	   BLK_State->unchk = 0;
	   BLK_State->nlaft = 0;
	   BLK_State->nlrpos = 1;
	   lines = optContextBefore+optContextAfter+2;
	   BLK_State->contextLines = malloc(lines*sizeof(TypeLine));
}

void process_block_clear(int i, BLK_SearchState *BLK_State) {
	TypeBlock *pblock;
	int length;
	int lines;
	int bytes;
	int oldptr;

	length=0;
	BLK_State->unchk = BLK_State->rpos - BLK_State->tpos;
	if (indPrintMatches) {
		lines = optContextBefore+1;
		bytes = BLK_State->rpos - BLK_State->ppos;
	} else {
		lines = 1;
		if (BLK_State->unchk > PatternList.lmax)
			bytes = BLK_State->unchk;
		else
			bytes = PatternList.lmax;
	}
        oldptr = OUTBUF_SIZE;
	do {
       	        pblock = get_block(i);
		while (bytes  && pblock->ref && lines) {
			if (CHR(pblock->c) == NEWLINE) {
				--lines;
				if (!lines) break;
			}
             		BLK_State->oldbuf[--oldptr] = CHR(pblock->c);
             		pblock = get_block(pblock->ref); 
             		length++;

		}
		i--;
	} while (bytes && lines && i);

}

int process_block_after_match(int i,BLK_SearchState *BLK_State) {
	TypeBlock *pblock = get_block(i);
	int lines,bytes,l,len,pos;
	int outptr;
	TypeLine *context = BLK_State->contextLines;
	int h;
	int nline;

	if (!indPrintMatches) {
		if (pblock->nlcount) {
		   BLK_State->tpos += pblock->nlcount;
		   BLK_State->nlaft = 0;
		} else {
                   BLK_State->tpos = BLK_State->rpos;
		}
	} else {
		outptr = OUTBUF_SIZE;
		if (pblock->nlcount >= BLK_State->nlaft) {
			lines = pblock->nlcount - BLK_State->nlaft+1;
			BLK_State->nlaft = 0;
		} else {
			BLK_State->nlaft -= pblock->nlcount;
	        	lines = 0;
		}
		pos = BLK_State->rpos;
		nline = BLK_State->nlrpos - lines;
		while (pblock->ref && lines) {
			if (CHR(pblock->c) == NEWLINE) lines--;
			pblock = get_block(pblock->ref);
			pos--;
		}
		bytes = 0;
		BLK_State->ppos+=pblock->length;
		len = pblock->length;
		l=0;
		while (pblock->ref) {
			BLK_State->buf[--outptr] = CHR(pblock->c); 
			if (CHR(pblock->c) == NEWLINE) {
				len = pblock->length;
				context[l].line = BLK_State->buf+outptr+1;
				context[l].nline = nline;
				context[l].len = bytes;
				context[l].match = 0;
				context[l].pos = pos;
				nline--;
				bytes = 0;
				l++;
			} else {
				bytes++;	
			}
			pblock = get_block(pblock->ref);
			pos--;
		}
		context[l].line = BLK_State->buf+outptr;
		context[l].nline = nline;
		context[l].len = bytes;
		context[l].match = 0;
		context[l].pos = pos;
		l++;
		BLK_State->tpos+=len;
		h=0;
		while (l>0) {
			l--;
			if (h) print_header(&context[l]);
			else h=1;
			printf("%.*s",context[l].len,context[l].line);
			if (l) printf("\n");
		}
		if (!BLK_State->nlaft) printf("\n");
	}
	return(0);
}

int process_block_match(int i,BLK_SearchState *BLK_State) {
	TypeBlock *pblock;


	if (indPrintMatches) {
		uncompress_blocks(i,BLK_State);
	} else {
       	        pblock = get_block(i);
		if (pblock->nlcount) {
		   BLK_State->tpos += pblock->nlcount;
		   BLK_State->nlaft = 0;
		} else {
                   BLK_State->tpos = BLK_State->rpos;
		   BLK_State->nlaft = 1;
		}
	}
	BLK_State->count++;
	BLK_State->unchk = 0;
	return(0);
}

void uncompress_blocks(int i,BLK_SearchState *BLK_State) {
	TypeBlock *pblock;
	int pos = BLK_State->rpos;
	int bytes;
	int lines = optContextBefore+1;
	int linesaft;
	int oldptr;
	int outptr;
	int tpos,ppos;
	int l=0;
	int mline;
	int nline;
	TypeLine *context = BLK_State->contextLines;


	bytes = 0;
	outptr = OUTBUF_SIZE;
	BLK_State->nlaft = optContextAfter+1;
	pblock = get_block(i);
	if (pblock->nlcount > optContextAfter) 
		linesaft = pblock->nlcount - optContextAfter;
	else 
		linesaft = 0;
        tpos = BLK_State->rpos;	
	ppos = 0;
	mline = 0;
	nline=BLK_State->nlrpos;
        do {
		while(pblock->ref && lines && pos > BLK_State->ppos) {
			BLK_State->buf[--outptr] = CHR(pblock->c);
                        if (CHR(pblock->c) == NEWLINE) {
				if (pos > BLK_State->tpos) {
					tpos = pos;
					if (linesaft) {
					     linesaft--;
					} else {
					     if (!ppos) ppos = pos;
					     context[l].line = BLK_State->buf+outptr+1;
					     context[l].len = bytes;
					     context[l].pos = pos;
					     context[l].match = 0;
					     context[l].nline = nline;
					     l++;
                                             BLK_State->nlaft--;
					}
				} else {
					if (mline) {
					   context[l].match = 1;
					   mline = 0;
					}
					context[l].line = BLK_State->buf+outptr+1;
					context[l].len = bytes;
					context[l].pos = pos;
					context[l].nline = nline;
					l++;
					lines--;
				}
				bytes=0;
				nline--;
			} else {
			    bytes++;
			}
			pblock = get_block(pblock->ref);
			pos--;
		}
		i--;
	        pblock = get_block(i);
	} while (i && lines && pos > BLK_State->ppos);
	BLK_State->tpos = tpos;

	oldptr = OUTBUF_SIZE;
	bytes = 0;
	while (lines && pos > BLK_State->ppos) {
             if (BLK_State->oldbuf[--oldptr] == NEWLINE) {
		     context[l].line = BLK_State->buf+outptr+1;
		     context[l].len = bytes;
		     context[l].pos = pos;
		     context[l].nline = nline;
		     bytes  = 0;
		     nline--;
		     l++;
		     lines --;
	     } else {
	             bytes++;
	     }
	     pos--;
	}

	if (BLK_State->count && !lines && (optContextBefore || optContextAfter)) printf("--\n");

	while (l > 0) {
		--l;
                if (indLinePrefix) print_header(&context[l]);
		printf("%.*s%s",context[l].len,context[l].line,
				(l?"\n":""));
	}

	BLK_State->ppos = (ppos?ppos:BLK_State->rpos);
}  

void print_header(TypeLine *contextLine) {
	char c;
	if (contextLine->match) c=':';
	else c = '-';
        if (optPrintFilename) printf("%s%c",filenameSearch,c);
	if (optLineNumber) printf("%d%c",contextLine->nline,c);
	if (optByteOffset) printf("%d%c",contextLine->pos,c);
}

int check_oldbuf(BLK_SearchState *BLK_State) {
  int i;
  int chk = 0; 
  TypePatternNode *p;
  int (*cmp) (const char *, const char *, size_t);

  if (optIgnoreCase) cmp = strncasecmp;
  else cmp = strncmp;
  p = PatternList.next_pattern;
  while (p!=NULL) {
     if (cmp(BLK_State->oldbuf+OUTBUF_SIZE-BLK_State->unchk,
			      p->pattern,BLK_State->unchk)==0) {
       chk=1;
       break;
     }
     p=p->next_pattern;
  }
  return(chk); 
}

int check_residual_patterns(int i,BLK_SearchState *BLK_State) {
   int outptr,oldptr;
   int length;
   TypePatternNode *p;
   int chk;
   TypeBlock *pblock;
   int (*cmp) (const char *, const char *, size_t);
   int offset;
   int bytes;

   outptr = OUTBUF_SIZE;
   length = 0;
   bytes = BLK_State->rpos - BLK_State->tpos + PatternList.lmax - PatternList.lmin;
   do {
      	        pblock = get_block(i);
		while (bytes>length  && pblock->ref) {
             		BLK_State->buf[--outptr] = CHR(pblock->c);
             		pblock = get_block(pblock->ref); 
             		length++;
		}
		i--;
	} while (bytes>length && i);
   
   oldptr=OUTBUF_SIZE;
   while(bytes>length && outptr) {
          BLK_State->buf[--outptr] = BLK_State->oldbuf[--oldptr];
	  length++;
   }

   if (optIgnoreCase) cmp = strncasecmp;
   else cmp = strncmp;
   chk=0;
   p = PatternList.next_pattern;
   while (p!=NULL) {
     offset = BLK_State->rpos - BLK_State->tpos + strlen(p->pattern) - PatternList.lmin;
     if (cmp(BLK_State->buf+OUTBUF_SIZE-offset,
			      p->pattern,strlen(p->pattern))==0) {
       chk=1;
       break;
     }
     p=p->next_pattern;
   }
  return(chk);

}
