#include "search_bm_onthefly.h"
#include "lzgrep.h"
#include "util.h"
#include "blocks.h"
#include "search.h"
#include <stdio.h>

static int B[256];
void preproc_bm_onthefly() {
	int c,i;
	int m = PatternList.lmin;
	char *patt = PatternList.next_pattern->pattern;
	static int preproc = 0;

	if (!preproc) preproc = 1;
	else return;

	for (c=0; c<256; c++) B[c] = m;
	for (i=0; i<(m-1); i++) {
		if (optIgnoreCase) {
		   B[tolower(patt[i])] = m-i-1;
		   B[toupper(patt[i])] = m-i-1;
		} else {
		   B[patt[i]] = m-i-1;
		}
	}
}

int search_bm_onthefly() {
	int rbytes;
	int l;
	int m = PatternList.lmin;
	char *patt = PatternList.next_pattern->pattern;
	int shift;
	OTF_SearchState OTF_State;

	OTF_cleanState(&OTF_State);
	while ((rbytes=OTF_readUncompressed(&OTF_State))>0) {
		while(OTF_State.rpos-OTF_State.tpos >= m) {
		      l=m;
		      while ((l>0) && equal(patt[l-1],OTF_charAt(OTF_State.tpos+l-1)))  l--;
		      if (l<=0) {
			      if (OTF_reportMatch(&OTF_State))
				      return(OTF_State.count);
		      } else {
		          shift= B[OTF_charAt(OTF_State.tpos+m-1)];
		          OTF_shift(OTF_State,shift);
		      }
	        }
	}
	return(OTF_State.count);
}
