/*   The author of this code is Gonzalo Navarro, 1996.
     This code can be freely used and distributed for teaching and research
     purposes, provided it is not modified and this notice is kept attached.
     No part of this code can be used for direct or indirect commercial
     advantage without written permission of the author.
*/


int newstate;

void Meter( GAutom G, uchar *pat, int num )

   { int j,state = 0;

	/* Advance in the trie following the pattern */

     j = 0;
     while (pat[j] && (G[state][pat[j]] != -1))
	 state = G[state][pat[j++]];

	/* Insert only if that pattern did not exist */

     while (pat[j])
        { G[state][pat[j++]] = ++newstate;
	  state = newstate;
	}
     G[state][0] = num;
   }

GAutom MakeG(uchar **Ps, int jj, int m)

   { int i,j;
     GAutom G = (GAutom) malloc ((m+1)*sizeof(*G));

     newstate = 0;
     for (i=0; i<=m; i++)
	for (j=0; j<Sigma; j++) G[i][j] = -1;

     for (i=0; i<jj; i++)
	 Meter(G,Ps[i],i);

     return G;
   }

void doAC (GAutom G, int m)

   { int *S = (void*)malloc ((m+1) * sizeof(int));
     int *C = (void*)malloc ((m+1) * sizeof(int));
     int b = 0, t = 0;
     int i,j,c;
     for (c=0;c<Sigma;c++)
         if (G[i][c] == -1) G[i][c] = 0;
         else { C[t] = c; S[t++] = i; }
     while (b < t)
        { c = C[b]; j = S[b++];
          i = G[j][c];
          if (j != 0) j = G[G[j][0]][c];  /* suffix link */
          G[i][0] = (G[i][0] == -1) ? j : - (j | ((G[i][0]+1) << 16));
          for (c=1;c<Sigma;c++)
             if (G[i][c] == -1) G[i][c] = G[j][c];
             else { C[t] = c; S[t++] = i; }
        }
     free (S); free (C);
   }
