#include "search.h"
#include "lzgrep.h"
#include "util.h"
#include <stdio.h>
#include <errno.h>

int insize; /* valid bytes in inbuf */
int inptr;  /* index of next byte to be processed in inbuf */
TypeByte inbuf[INBUF_SIZE+INBUF_EXTRA];

/* ===========================================================================
 *  * Fill the input buffer. This is called only when the buffer is empty.
 *   */
int fill_inbuf()
{
    int len;

    /* Read as much as possible */
    insize = 0;
    errno = 0;
    do {
        len = read(fdSearch, (char*)inbuf+insize, INBUF_SIZE-insize);
        if (len == 0 || len == EOF) break;
        insize += len;
    } while (insize < INBUF_SIZE);

    if (insize == 0) {
        if (errno != 0) {
           perror(filenameSearch);
        } else {
           fprintf(stderr, "%s: unexpected end of file\n",filenameSearch);
        }
        exit(2);
    }
    inptr = 1;
    return inbuf[0];
}

/* Returns format method of compression: unsuported, LZW or LZ77 */
CompressFormat get_format() {
     char c;
     inptr=1;
     insize=0;
     if ((c=getbyte()) != '\037') return(unsupported_format);
     switch(c=getbyte()) {
	     case '\235':   /* Magic header for lzw files, 1F 9D */
		     return(LZW_format);
	     case '\213':   /* Magic header for gzip files, 1F 8B */
		     return(LZ77_format);
	     case '\236':  /* Magic header for gzip 0.5 = freeze 1.x */ 
		     return(LZ77_format);
	     default: 
		     return(unsupported_format);
     }
}

/* Process a match for algorithms of blocks */
/*int process_block_match(int i,int *count, int *nlaft, 
		int rpos, int *tpos, int unchk, int prtpos,int nlrpos){
    int brk = 0;
    int nlbef;
    int lenaft;
    int lenbef;
    int tp;
    int j,k;
    int prsep;
    int nltpos;


    prsep = *count && (optContextBefore || optContextAfter) && indPrintMatches && !optOnlyMatching;
    if (prsep)
       printf("--\n");
    ++*count;

    /- Uncompress context buffer -/
    nlbef = optContextBefore +1;
    *nlaft = (indPrintMatches ? optContextAfter +1 : 1);
    lenaft = rpos - *tpos - unchk;
    lenbef = *tpos - prtpos;
    k=i;
    tp = *tpos;
    j=save_after_blocks(&k,tpos,&lenaft,nlaft,&nltpos);
    if (indPrintMatches) {
      if (optOnlyMatching) {
	  lenbef=unchk;
          save_before_blocks(j,k,tp,&lenbef,&nlbef,nlrpos-nltpos);
          print_saved_blocks(PatternList.lmin);
	  printf("\n");
      } else {
          save_before_blocks(j,k,tp,&lenbef,&nlbef,nlrpos-nltpos);
          print_saved_blocks(lenbef+lenaft);
      }
    }
    return(brk);
}*/

/* Process after a match for algorithms of blocks */
/*int process_block_after_match(int i,int count, int *nlaft, int rpos,int *tpos, int prtpos, int nlrpos) {
	int lenaft;
	int brk = 0;
	int aux;
	int nltpos;

	if (count == optStopAfter) brk = 1;
	lenaft = rpos - prtpos;
	aux=*nlaft;
	save_after_blocks(&i,tpos,&lenaft,nlaft,&nltpos);
	if (indPrintMatches && !optOnlyMatching) {
		print_saved_blocks(lenaft);
		if (indLinePrefix && *nlaft && (*nlaft != aux)) {
		     if (optPrintFilename)
		        printf("%s-",filenameSearch);
		     if (optLineNumber)
		        printf("%d-",nlrpos-nltpos+1);
		     if (optByteOffset)
		        printf("%d-",*tpos);
		}
	}
	return(brk);
}*/
