/* This code is from Gonzalo Navarro and Mathieu Raffinot, 1998.
   It can be freely used for academic teaching/learning and research
   purposes. Usage for direct or indirect commercial advantage is not
   allowed without written permission from the authors.
*/


#include <stdio.h>
#include "lzgrep.h"
#include "util.h"
#include "blocks.h"
#include "search.h"

#include "oracle.c"
#include "search_bom_onthefly.h"

typedef unsigned char uchar;


/*************** add a simple word *********************/
void
preproc_bom(int m,unsigned char* motif,int * * T) {
 int i;
 int der;
 int activenode =0;


 *T=allocation_dawg(m+1); /* allocation of the table for the DAWG */
 if (*T==NULL) {
   fprintf(stderr,"impossible to allocate the table for the DAWG");
   exit(-1);
 }

 init_dawg_table(*T,m+1);
 der=0;   /* last state used in the table */

  for(i=m-1;i>=0;i--) {
           dawg_update(*T,&der,&activenode,(int)motif[i]); /* ajout dans le graphe */
    }

}


int *T;


void preproc_bom_onthefly ()
   {
 	int m = PatternList.lmin;
	char *patt = PatternList.next_pattern->pattern;
	static int preproc = 0;
	if (!preproc) preproc = 1;
	else return;
	preproc_bom(m,patt,&T);
   }


int search_bom_onthefly() {

	int rbytes; 

	register int j,state; 
        register int *T2;

	char *patt = PatternList.next_pattern->pattern;
	int m = PatternList.lmin;
	register int mM1=m-1;
	OTF_SearchState OTF_State;
	OTF_cleanState(&OTF_State);
	T2 = T+6;
	while ((rbytes=OTF_readUncompressed(&OTF_State))>0) {
  	      while(OTF_State.tpos < OTF_State.rpos) {
                          j = mM1;
		          while ((state = T2[OTF_charAt(OTF_State.tpos+j)]) < 0) {  
				OTF_shift(OTF_State,m);			
			  }
                         
			  while (1)
			  {
			      
	  		     if (j == 0) {
					  if (OTF_reportMatch(&OTF_State)) {
						return(OTF_State.count);
					  }
					  break;
			          }
			      j-=1;
			      state = T2[state*(ALPHABET+6)+ OTF_charAt (OTF_State.tpos+j) ];
			      if (state == -1) break;
			  }
		  
                          OTF_shift(OTF_State,j+1);
			  			  
		}
		OTF_State.tpos=OTF_State.rpos;
	  }
     return(OTF_State.count);
 
}

