#include "search_bmmultichar_multi.h"
#include "lzgrep.h"
#include "format.h"
#include "blocks.h" 

static unsigned char *mask;
static int bytes_mask;
static int ibytes_mask;
#define reset_mask { ibytes_mask=bytes_mask;while(ibytes_mask--) mask[ibytes_mask] = 0xFF; }
#define set_empty_flag(flag) {flag=0;ibytes_mask=bytes_mask;while(ibytes_mask--) flag |= mask[ibytes_mask];}
#define and_mask(c,i) {ibytes_mask=bytes_mask;while(ibytes_mask--) mask[ibytes_mask] &=M[c][i][ibytes_mask];}
static unsigned char **M[256];

#define HTSIZE 1017
static int *B[HTSIZE];
/* #define HASH(c) ((c & ((1 << (8*BLK))-1)) % HTSIZE)  */
#define HASH(c) (c % HTSIZE)  /* simpler for BLK = sizeof(unsigned long) */
#define MSHIFT(cc,c,n) ((cc << (8*(n))) | c)
#define SHIFT(cc,c) MSHIFT(cc,c,1)
#define LAST(cc,n) (cc & ((1 << (8*(n)))-1)) /* does NOT work for n >= 4 */
#define LOWERCASE(cc) (tolower(cc&0xFF) || (tolower((cc>>1)&0xFF) <<1) || (tolower((cc>>2)&0xFF)<<2) || (tolower((cc>>3)&0xFF) << 3)) /* does NOT work for more than 4 bytes */


void preproc_bmmultichar_multi (int use_mask);
void preproc_bmmultichar_multi_1 () {
	preproc_bmmultichar_multi(1);
}
void preproc_bmmultichar_multi_2 () {
	preproc_bmmultichar_multi(0);
}

static void preprocB (int BLK) {
     int c,i,j,k;
     int m = PatternList.lmin;
     int *BB;
     TypePatternNode *next;
     char *pt;
     unsigned long cc;

     if (m < BLK) {
	     fprintf (stderr,"For this implementation m >= %i\n",BLK);
	     exit(2);
     }

     BB = (void *)malloc (HTSIZE*m*sizeof(int));
     for (c=0;c<HTSIZE;c++) B[c] = BB + c*m;

     k=0;
     next = PatternList.next_pattern;
     while (next != NULL) {
	     pt=next->pattern+strlen(next->pattern)-PatternList.lmin;
	     for (i=BLK-1;pt[i];i++)
		     for (c=0;c<HTSIZE;c++)
			     if (!k || (B[c][i] > (i+1-(BLK-1))))
				     B[c][i] = i+1-(BLK-1);
	     cc = 0; 
	     for (i=0;i<BLK-1;i++) cc = SHIFT(cc,pt[i]);
	     for (;pt[i];i++) {
		     cc = SHIFT(cc,pt[i]);
		     if (optIgnoreCase) cc = LOWERCASE(cc);
		     for (j=i;pt[j];j++)
			     if (!k || (B[HASH(cc)][j] > (j-i)))
				     B[HASH(cc)][j] = j-i;
	     } 
	     k++;
	     next = next->next_pattern;
     }
}

static int* B1[256];

void preproc_bmmultichar_multi (int use_mask) {
	int c,i,j,k;
	int m = PatternList.lmin;
	int *BB;
	void *MM;
	void *MMM;
	TypePatternNode *next;
	char *pt;
	static int preproc = 0; 
	int BLK = sizeof(unsigned long);

	if (!preproc) preproc = 1;
	else return;

	preprocB(BLK);
	BB = (void *)malloc (256*m*sizeof(int));
	if (use_mask) {
		bytes_mask=((PatternList.count-1)>>3)+1;
		mask = (unsigned char *)malloc(bytes_mask*sizeof(unsigned char));
		MM = (void *) malloc (256 * m *sizeof(unsigned char *));
		MMM = (void *) malloc (256 * m *bytes_mask*sizeof(unsigned char));
	}
	for (c=0;c<256;c++) {
		B1[c] = BB + c*m; 
		if (use_mask) {
			M[c] = (unsigned char **)MM + c*m;
			for (i = 0; i < m; i++) {
				M[c][i] = (unsigned char *)MMM+c*m*bytes_mask+i*bytes_mask;
				for(j=0;j<bytes_mask;j++) M[c][i][j]=0;
			}
		}
	}
	
	k=0;
	next = PatternList.next_pattern;
	while (next != NULL) {
	     pt=next->pattern+strlen(next->pattern)-PatternList.lmin;
	     for (i=0;pt[i];i++) {
		     if (use_mask) {
			     j = k>>3;
			     if (optIgnoreCase) {
				     M[tolower(pt[i])][i][j] |= 1 << (k&0x7);
				     M[toupper(pt[i])][i][j] |= 1 << (k&0x7);
			     } else {
				     M[pt[i]][i][j] |= 1 << (k&0x7);
		             }
		     }
		     for (c=0;c<256;c++)
			     if (!k || (B1[c][i] > (i+1)))
				     B1[c][i] = i+1;
	     }
	     for (i=0;pt[i];i++) {
		     for (j=i;pt[j];j++) {
			     if (!k || (B1[pt[i]][j] > (j-i)))
				     if (optIgnoreCase) {
					     B1[tolower(pt[i])][j] = j-i;
					     B1[toupper(pt[i])][j] = j-i;
				     } else {
					     B1[pt[i]][j] = j-i;
				     }
		     }
	     }
	     k++;
	     next = next->next_pattern;
	}
}
int search_bmmultichar_multi (int opt);
int search_bmmultichar_multi_1() {
	return(search_bmmultichar_multi(1));
}
int search_bmmultichar_multi_2() {
	return(search_bmmultichar_multi(2));
}

int search_bmmultichar_multi (int opt)
{
  register int m = PatternList.lmin;
  register long i, k, j, length, oldj;
  register long from;
  unsigned long code;
  register int offset, shift;
  register int c;
  int flag;
  int BLK = sizeof(unsigned long);
  TypeBlock *pblock_i, *pblock, *pblock_j;
  BLK_SearchState BLK_State;
  int brk;


  BLK_CleanState(&BLK_State);
  BLK--;

  for (j=-1; j <  FirstFree; j++) {
        pblock=get_block(j);
        pblock->length=0;
        pblock->ref = 0;
        pblock->nlcount=0;
        pblock->c=j+1;
  }

  i = free_ent = FirstFree;

  pblock = get_block(i-1);
  pblock->c = oldj = getcode ();
  BLK_State.rpos++;
  if (oldj == -1)
    return (BLK_State.count); 
  if (opt==1) reset_mask;

  while (1)
   {
     readBlocks:
      while (BLK_State.rpos - BLK_State.tpos <= m) {
	if ((j = getcode ()) == -1) goto endText;
	if (j == Clear) {
	    process_block_clear(i,&BLK_State);
	    free_ent = i = FirstFree - 1;
	    if ((j = getcode ()) == -1) goto endText;
	    pblock = get_block(i-1);
	    pblock->c = j;
	}
	if (free_ent < maxmaxcode)
	  i = free_ent++;
	else
	  i++;
	pblock_j=get_block(oldj);
	pblock=get_block(j-1);
	c = pblock->c;
	pblock = get_block(i-1);
	pblock_i=get_block(i);
	pblock_i->ref = oldj;
	length = pblock_j->length;
	if (length < BLK) /* path the mask of characters */
		code = MSHIFT(pblock->c,
				SHIFT(LAST(pblock_j->c,length),LAST(c,1)),
				length+1);
	else
		code = SHIFT(pblock_j->c,LAST(c,1));
	pblock_i->c = code;
	pblock_i->length=++length;
	oldj = j;
	BLK_State.rpos += pblock_i->length;
	 if (indPrintMatches) {
               pblock_i->nlcount = pblock_j->nlcount;
              if (LAST(pblock_i->c,1)==NEWLINE)
                       pblock_i->nlcount++;
              BLK_State.nlrpos += pblock_i->nlcount;
         } else {
              if (pblock_j->nlcount)
                  pblock_i->nlcount = pblock_j->nlcount;
              else if (LAST(pblock_i->c,1)==NEWLINE)
                  pblock_i->nlcount = pblock_i->length;
              else  pblock_i->nlcount = 0;
         }
	 /* If is a matched line */
	 if (BLK_State.nlaft)  {
	      brk=process_block_after_match(i,&BLK_State);
	      if (brk) goto endText;
	 }
      }

    /* now I've read one extra block. try to shift */
    j = i;
    from = BLK_State.rpos;
    pblock = pblock_i;
    while (1)
     {
      from -= pblock->length;
      pblock = get_block(j-1);
      offset = from - 1 - BLK_State.tpos;
      if (offset < BLK_State.unchk) break;
      if (optIgnoreCase)
	      shift = B[HASH(LOWERCASE(pblock->c))][offset];
      else
	      shift = B[HASH(pblock->c)][offset];
      if (shift > 0) {
	      if (BLK_State.unchk) {
		      if (BLK_State.unchk > shift)
			      BLK_State.unchk-=shift;
		      else
			      BLK_State.unchk=0;
	       }
		BLK_State.tpos += shift;
		if (opt==1) reset_mask;
		goto readBlocks;
      }
      j--;
    }

    /* unable to shift by blocks,try characters */
    j = i - 1;
    from = BLK_State.rpos -pblock_i->length;
    while (1)
     {
      pblock = get_block(j);
      from -= pblock->length;
      length = pblock->length;
      k = j;
      offset = from - BLK_State.tpos -1;
      if (offset + length < BLK_State.unchk) goto expandLast;
      while (length > BLK_State.unchk)
       {
	pblock=get_block(k);
	shift = B1[LAST(pblock->c,1)][offset+length];
	if (shift > 0) {
	  if (BLK_State.unchk) {
	       if (BLK_State.unchk > shift)
		       BLK_State.unchk -= shift;
	       else BLK_State.unchk = 0;
	  }
	  BLK_State.tpos += shift;
	  if (opt==1) reset_mask;
	  goto readBlocks;
	} else if (opt==1) { 
		and_mask(LAST(pblock->c,1),offset+length);
	}
	k = pblock->ref;
	length--;
	if (offset + length < BLK_State.unchk)
	  goto expandLast;
      }
      j--;
    }

    /* only the last (i-th) block rests to be tested */
  expandLast:
    length = pblock_i->length;
    j = i;
    from = BLK_State.rpos - pblock_i->length;
    offset = from - BLK_State.tpos -1;
    pblock=pblock_i;
    while (offset + length +BLK_State.unchk>= m)
     {
      j = pblock->ref;
      pblock=get_block(j);
      length--;
    }
    while ((length > 0) && (offset + length >= BLK_State.unchk))
     {
      shift = B1[LAST(pblock->c,1)][offset + length];
      if (shift > 0) {
	if (BLK_State.unchk) {
		if (BLK_State.unchk > shift)
			BLK_State.unchk-=shift;
		else
			BLK_State.unchk=0;
	}
	BLK_State.tpos += shift;
	if (opt==1) reset_mask;
	goto readBlocks;
      } else if (opt==1) {
	      and_mask(LAST(pblock->c,1),offset+length);
      }
      pblock = get_block(pblock->ref);
      length--;
    }

    if (opt==1) { 
	    set_empty_flag(flag);
	    reset_mask;
	    if (!flag) {
		    BLK_State.tpos++;
		    goto readBlocks;
	    }
    }
    
    /* Check uncheked text */
    if (BLK_State.unchk) {
         if (!check_oldbuf(&BLK_State)) {
               BLK_State.tpos++;
               BLK_State.unchk--;
               goto readBlocks;
	 }
     }

     /* Check patterns longer than lmin */
    if (!check_residual_patterns(i,&BLK_State)) {
	    BLK_State.tpos++;
	    if (BLK_State.unchk) BLK_State.unchk--;
	    goto readBlocks;
    }

    /* it passed all the tests, report the match */
    process_block_match(i,&BLK_State);
  }
endText:return (BLK_State.count);
}
