#include "search_bmblocks.h"
#include "lzgrep.h"
#include "format.h"
#include "blocks.h"
#include "util.h"

static int **J;   /* J[l,i] = endpoint of last occurrence of P[i-l+1..i] in
	                              P[0..i-1] */
static int ***J1;   /* J[l,i,c] = endpoint of last occurrence of P[i-l+1..i] in
		                        P[0..i-1], followed by c */
static int ***J2;   /* J[l,i,p] = endpoint of last occurrence of P[i-l+1..i] in
		                        P[0..i-1], before p */
void preproc_J() {
     int i,j,l,bits;
     int *JJ;
     int m = PatternList.lmin;
     char *patt = PatternList.next_pattern->pattern;

     JJ = (void *)malloc ((m+1)*m*sizeof(int));
     J = (void *)malloc ((m+1)*sizeof(int*));
     for (l=0;l<=m;l++) J[l] = JJ + l*m;
		/* this is O(m^2), not O(m^3) as it may seem */
     for (l=0;l<=m;l++) J[l][0] = -1;
     for (i=0;i<m;i++) J[0][i] = i-1;
     for (l=1;l<=m;l++)
        for (i=1;i<m;i++)
	   { j = J[l-1][i-1];
	     while ((j>=0) && (patt[j+1] != patt[i]))
		j = J[l-1][j];
	     if ((j == -1) && (patt[j+1] != patt[i]))
		j--;
	     J[l][i] = j+1;
	   }
}

void preproc_2J() {
     int i,j,l,k;
     int m = PatternList.lmin;
     char *patt = PatternList.next_pattern->pattern;
     int *JJ1, *JJ2;
     int **JJJ1,**JJJ2;
     int c;
     int lpos;

     JJJ1 = (void *)malloc (256*(m+1)*m*sizeof(int));
     JJ1 = (void *)malloc ((m+1)*m*sizeof(int*));
     J1 = (void *)malloc ((m+1)*sizeof(int*));   
 
     JJJ2 = (void *)malloc (m*(m+1)*m*sizeof(int));
     JJ2 = (void *)malloc((m+1)*m*sizeof(int*));
     J2 = (void *)malloc((m+1)*sizeof(int*));
 
     for (l=0;l<=m;l++)  {
          J1[l] = (int **)JJ1 + l*m;
          J2[l] = (int **)JJ2 + l*m;
          for (j=0;j<m;j++) {
              J1[l][j] = (int *)JJJ1+256*m*l+256*j;
              J2[l][j] = (int *)JJJ2+m*m*l+m*j;
          }
     } 

     /* this is O(m^3), not O(m^4) as it may seem */
 
    for (k=0; k<m;k++) {
       for (l=0;l<=m;l++)
           J2[l][0][k] = -1;
 
       lpos=-1;
       for (i=1;i<m;i++) {
          if ((i-1)<=k) lpos=i-1;
          J2[0][i][k] = i-1;
       }
    }
    for (c=0;c<256;c++) {
       for (l=0;l<=m;l++)
           J1[l][0][c] = -1;
 
       lpos=-1;
       for (i=1;i<m;i++) {
           if (patt[i]==c) lpos=i-1;
           J1[0][i][c] = lpos;
       }
    }      
 
     for (l=1;l<=m;l++)
        for (i=1;i<m;i++) {
         if ((patt[0]==patt[i]) && (l==1)) J2[l][i][0] = 0;
         else J2[l][i][0]=-1;
         for(k=1;k<m;k++) {
            j = J2[l-1][i-1][k-1];
            while ((j>=0) && (patt[j+1] != patt[i]))
              j = J2[l-1][j][k-1];
            if ((j == -1) && (patt[j+1] != patt[i]))
              j--;
            J2[l][i][k] = j+1;
         }   

         for(c=0;c<256;c++) {
             j = J1[l-1][i-1][patt[i]];
             while ((j>=0) && (patt[j+2] != c))
                j = J1[l-1][j][patt[i]];
             if ((j == -1) && (patt[j+2] != c))
                j--;
             J1[l][i][c] = j+1;
         }
       }
}

void preproc_bmblocks_1() {
	preproc_J();
}
void preproc_bmblocks_2() {
	preproc_J();
}
void preproc_bmblocks_3() {
	preproc_2J();
}

int search_bmblocks(int opt);
int search_bmblocks_1() {  /* BM-blocks */
	return(search_bmblocks(1));
}
int search_bmblocks_2() {  /* BM-blocks-opt */
	return(search_bmblocks(2));
}
int search_bmblocks_3() {  /* BM-blocks-2j */
	return(search_bmblocks(3));
}
int search_bmblocks(int opt) {
	int  i,j,k,l,oldj,pos;
	int length,from,offset,shift;
	int m = PatternList.lmin;
	char *patt = PatternList.next_pattern->pattern;
	int brk;
	TypeBlock *pblock_i, *pblock,*pblock_j;
	BLK_SearchState BLK_State;

	BLK_CleanState(&BLK_State);
	for (j=-1; j <  FirstFree; j++) {
		pblock=get_block(j);
	        pblock->length=0;
	        pblock->ref = 0;
		pblock->nlcount=0;
		pblock->c=j+1;
		pblock->last=m-1;
	}
	i = free_ent = FirstFree;

	pblock=get_block(i-1);
	pblock->c = oldj = getcode();
	BLK_State.rpos++;
	if (oldj == -1) return(BLK_State.count);

	while(1) {
   		readBlocks:
		while (BLK_State.rpos - BLK_State.tpos <= m) {
			if ((j=getcode()) == -1) goto endText;
			if (j == Clear) {
				process_block_clear(i,&BLK_State);
				free_ent = i = FirstFree - 1;
				if ((j=getcode()) == -1) goto endText;
				pblock=get_block(i-1);
				pblock->c = j;
			}
			if (free_ent < maxmaxcode) 
				i = free_ent++;
			else 
				i++;
			pblock_j=get_block(oldj);
			pblock=get_block(j-1);
			pblock_i=get_block(i);
			pblock_i->ref = oldj;
			pblock_i->c = pblock->c;
			length=pblock_j->length;
			pos = pblock_j->last;
			oldj = j;
			if (length>m) l=m;
			else l=length;
			if (opt==3) {
			      if ((pos>=0) && (patt[pos+1] != pblock->c))
			      	pos = J1[l][pos][pblock->c];
			} else {
			      while ((pos >= 0) && ((pos==m-1) || 
					 patt[pos+1] != pblock->c))
				     pos = J[l][pos];
			}
		        if ((pos==-1) && (patt[0] != pblock->c)) pos--;
			pblock_i->last=++pos;
			pblock_i->length=length+1;
			BLK_State.rpos += pblock_i->length;
			if (indPrintMatches) {
				pblock_i->nlcount = pblock_j->nlcount;
				if (pblock_i->c==NEWLINE)
					pblock_i->nlcount++;
				BLK_State.nlrpos += pblock_i->nlcount;
			} else {
				if (pblock_j->nlcount)
			    		pblock_i->nlcount = pblock_j->nlcount;
		        	else if (pblock_i->c==NEWLINE)
                            		pblock_i->nlcount = pblock_i->length;
				else  pblock_i->nlcount = 0;
			}
                        /* If is a matched line */
			if (BLK_State.nlaft)  {
				brk=process_block_after_match(i,&BLK_State);
			        if (brk) goto endText;
                        }
			if (opt>=2) {
				offset = BLK_State.rpos - BLK_State.tpos;
				if (offset > m) break;
				if ((pos+1) < offset) 
					BLK_State.tpos+=(offset-pos-1);
			}
		}

		/* now I've read one extra block, try to shift */
		j = i-1;
		pblock = pblock_i;
		from = BLK_State.rpos - pblock->length;
		while (1) {
			offset = from -1 -BLK_State.tpos;
			pblock=get_block(j);
			from -= pblock->length;
			if (offset < BLK_State.unchk) break;
			pos = pblock->last;
			if (pos > offset) {
				l = pblock->length;
				if (l>m) l=m;
				if (opt==3) {
					pos = J2[l][pos][offset];
				} else {
					do pos = J[l][pos];
					while (pos > offset);
				}
			}
			if (pos < offset)
				shift = offset-pos;
			else 
				shift = 0;
			if (shift > 0) {
                                if (BLK_State.unchk) {
                                    if (BLK_State.unchk > shift) 
					   BLK_State.unchk-=shift;
                                    else 
					   BLK_State.unchk = 0;
                                } 
				BLK_State.tpos += shift;
				goto readBlocks;
			}
			j--;
		}

		/* only the last (i-th) block rests to be tested */
		j=i;
		from = BLK_State.rpos - pblock_i->length;
		length = pblock_i->length;
		offset = from - 1 - BLK_State.tpos -m;
		pblock=pblock_i;
		while (offset+length >= BLK_State.unchk) {
			pblock=get_block(pblock->ref);
			length--;
		}
		pos = pblock->last;
		if ((pos+BLK_State.unchk+1) < (m-1)) {
		   shift = m -1 -pos;
		} else {
		   shift=0;
		}
		if (shift > 0) {
                      if (BLK_State.unchk) {
                              if (BLK_State.unchk > shift) 
				    BLK_State.unchk-=shift;
                              else 
				    BLK_State.unchk = 0;
                       } 
		       BLK_State.tpos += shift;
		       goto readBlocks;
		}
		
                /* Check uncheked text */
                if (BLK_State.unchk) {
                    if (!check_oldbuf(&BLK_State)) {
                           BLK_State.tpos++;
                           BLK_State.unchk--; 
			   goto readBlocks;
                    }
                }
		/* It passed all the tests, report the match */
		brk=process_block_match(i,&BLK_State);
		if (brk) goto endText;
	}
	endText:
		return(BLK_State.count);
}
