/* Search state for on-the-fly algorithms */
typedef struct {
	unsigned long tpos;  /* Search position */
	unsigned long rpos;  /* Read position */
	unsigned long ppos;  /* Position of last printed line */
	unsigned char *oldbuf; /* Buffer of recent read */
	unsigned char *buf;  /* Buffer of current read */
	unsigned long count; /* Number of matches */
	unsigned long linenum; /* Line num in tpos */
} OTF_SearchState;

/* lines to report */
typedef struct _linelist {
	unsigned char *buf;
	int len;
	int pref; /* Print prefix of line */
	int pos; /* tpos for start of line */
	struct _linelist *next;
} LineList;
#define BITS_BUF 15
#define BUF_SIZE (unsigned long)0x8000
#define DOBLE_BUF_SIZE (unsigned long) 0x10000
#define BUF_MASK (unsigned long) 0xFFFF
#define OTF_charAt(i) SBUFF[i&BUF_MASK]
#define OTF_shift(otf,sf) {if (optLineNumber) OTF_shift2(&otf,sf); else otf.tpos+=sf;}

#define equal(a,b) (optIgnoreCase?tolower(a)==tolower(b):a==b)

extern unsigned char SBUFF[];
int search();
void set_default_algorithm(char *algname);
void OTF_cleanState(OTF_SearchState *OTF_State);
int OTF_readUncompressed(OTF_SearchState *OTF_State);
int OTF_reportMatch(OTF_SearchState *OTF_State);
void OTF_shift2(OTF_SearchState *OTF_State,int shift);
