typedef struct {
	unsigned short length;
	unsigned short ref;
	unsigned long c;
	unsigned short nlcount;
	unsigned short type;
	unsigned short node;
	short last;
} TypeBlock;

extern TypeBlock *low_blocks;
extern TypeBlock *hi_blocks;

typedef struct {
        char *line;
        int len;
	unsigned long pos;
	int match;
	int nline;
} TypeLine;


/* State of search */
typedef struct {
	long tpos;
	long rpos;
	long ppos;
	int unchk;
	unsigned char *oldbuf;
	unsigned char *buf;
	unsigned long count;
	unsigned long nlrpos;
	int nlaft;
	TypeLine *contextLines;
} BLK_SearchState;

#define OUTBUF_SIZE 0x8000

extern char outbuf[]; /* Buffer of uncompressed data */
extern char oldbuf[]; /* Buffer of uncompressed data */


#define blmask  (int)0xFFFF
#define get_block(i) (i<blmask?&low_blocks[i]:&hi_blocks[i&blmask])

void uncompress_blocks(int i,BLK_SearchState *BLK_State);
int process_block_match(int i,BLK_SearchState *BLK_State);
int process_block_after_match(int i,BLK_SearchState *BLK_State);
void process_block_clear(int i, BLK_SearchState *BLK_State);

int check_oldbuf(BLK_SearchState *BLK_State);
int fill_outbuf();
void print_header(TypeLine *contextLine);
int check_residual_patterns(int i,BLK_SearchState *BLK_State);
