
int MEM=0;
int reportLevel=0;

#include <stdlib.h>
#include <stdio.h>
#if 1
 #include <sys/timeb.h>
#else
 #include <sys/time.h>
 #include <sys/resource.h>
#endif
#include "comparray4.h"

#if 1
typedef struct timeb mytimestruct;
void mygettime(mytimestruct *t)
{
  ftime(t);
}
double mylaptime(mytimestruct *before,mytimestruct *after)
{
  double t;
  t = after->time - before->time;
  t += (double)(after->millitm - before->millitm)/1000;
  return t;
}
#else
typedef mytimestruct struct rusage;
void mygettime(mytimestruct *t)
{
  getrusage(RUSAGE_SELF,t);
}
double mylaptime(mytimestruct *before,mytimestruct *after)
{
  double t;
  t = after->ru_utime.tv_sec - before->ru_utime.tv_sec;
  t += (double)(after->ru_utime.tv_usec
		- before->ru_utime.tv_usec)/1000000;
  return t;
}
#endif

CSA SA;

extern int rankb_w,rankb_m,rankb_w2;

int main(int argc, char *argv[])
{
   int i, *p;
   int n;
   unsigned char *s;
   char *fnam;
   FILE *f,*in;
   char fname1[128],fname2[128];

   if (argc<2) {
      fprintf(stderr, "syntax: suftest file\n");
      return 1;
   }
   fnam=argv[1];
#if 1
   rankb_w = 16;
   rankb_w2 = 128;
   if (argc>=3) rankb_w = atoi(argv[2]);
   if (argc>=4) rankb_w2 = atoi(argv[3]);
   printf("D=%d (stores SA for every D)\n",rankb_w);
   printf("L=%d (directory for Psi)\n",rankb_w2);
#endif

   if (! (f=fopen(fnam, "rb"))) {
      perror(fnam);
      return 1;
   }
   if (fseek(f, 0L, SEEK_END)) {
      perror(fnam);
      return 1;
   }
   n=ftell(f);
   if (n==0) {
      fprintf(stderr, "%s: file empty\n", fnam);
      return 0;
   }
   p=malloc((n+1)*sizeof *p);
   if (! p) {
      fprintf(stderr, "malloc failed (%i)\n",(n+1)*sizeof *p);
      return 1;
   }
   s=malloc(n * sizeof *s);
   if (! s) {
      fprintf(stderr, "malloc failed (%i)\n",n * sizeof *s);
      return 1;
   }

   rewind(f);
   fread(s,sizeof(*s),n,f);

   sprintf(fname1,"%s.sa",argv[1]);

   if (! (in=fopen(fname1, "rb"))) {
      perror(fname1);
      return 1;
   }
   fread(p+1,sizeof(*p),n,in);
   p[0] = n;

   /* ̕ 0..n-1  n Ԗڂɂ 0 B
      p[0] ͕K n ɂȂBp[1..n]0..n-1ĂB*/
   for (i=0; i<=n; ++i) p[i]++;  /* p[1..n]1..nĂBp[0]=n+1*/

   sprintf(fname1,"%s.psi",argv[1]);
   sprintf(fname2,"%s.idx",argv[1]);

   csa_new(n,p,s,fname1,fname2);
   printf("write ok\n");
   return 0;
}
