#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <math.h>
#include <GL/gl.h>
#include <GL/glut.h>
#include <unistd.h>

#include "bmp.c"
#define STEP 1



#define	X					0
#define	Y					1
#define	Z					2
#define	RED					0
#define	GREEN				1
#define	BLUE				2
#define	ALPHA				3
#define	PI					3.14159265
#define COLA 300
#define sinf(X) (float)sin((float)X)




/* MIS VARIABLES  */
char *path="/root/cc52b/proyecto";
float rot=0;
long t=0;
float dt=0.005;
struct bola* raiz;
char *textur;
char camara='l';
struct bola* chase=NULL;
int tail=0;
int lugar=49;

struct punto3D {
	float x;
	float y;
	float z;
};

struct bola {
	struct punto3D pos;
	struct punto3D vel;
	struct punto3D acel;
	float tail[COLA][3];
	float masa;
	float radio;
	char *tex;
	GLuint n;
	struct bola* sgte;
};


/**> GLOBAL VARIABLES <**/
// Textures
GLuint			gCloudsTexture;
GLuint			gStoneTexture;
GLuint			gPillarTexture;
GLuint			gWaterTexture;
// Lights stuff
GLfloat			gLightAmbient[] = { 0.5, 0.5, 0.5, 1.0 };
GLfloat			gLightDiffuse[] = { 1.0, 1.0, 1.0, 1.0 };
GLfloat			gLightPosition[] = { 0.0, 1.0, 2.0, 1.0 };
// Material Stuff
GLfloat			gMaterialAmbient[] = { 0.5, 0.5, 0.5, 1.0 };
GLfloat			gMaterialDiffuse[] = { 0.5, 0.5, 0.5, 1.0 };
GLfloat			gMaterialSpecular[] = { 0.9, 0.9, 0.9, 1.0 };
GLfloat			gMaterialShininess = 40;
// Misc stuff
GLfloat			gCameraRot[3] = { 0, 0, 0 };
GLfloat			gMonoRot[3] = { 0, 0, 0 };
GLfloat			gCameraXPos = 0;
GLfloat			gCameraYPos = 0;
GLfloat			gCameraZPos = -75;
GLfloat			gMonoXPos = 15;
GLfloat			gMonoYPos = 5;
GLfloat			gMonoZPos = 25;
GLfloat			gWaterMotion = 0;
GLfloat			gFogColor[] = { 0.8, 0.8, 1.0, 1.0 };
GLfloat			gCloudMotion = 0;
GLdouble		gClipPlane[] = { 0, 1, 0, 0 };
GLdouble        gClipPlane1[] = { 0,-1, 0, 0 };
GLUquadricObj 	*gQuadratic;
GLboolean		gWireframe = GL_FALSE;
GLboolean		gROT = GL_FALSE;
GLboolean		gCAM = GL_TRUE;


/**> FUNCTION PROTOTYPES <**/
void	InitGL( void );
void	Reshape3D( int w, int h );
void	DisplayGLScene( void );
void	DrawWater( void );
void	Keyboard( unsigned char key, int x, int y );
void	Special( int key, int x, int y );



struct punto3D S[1001];
struct punto3D cp3D(float x,float y,float z);
void copiar(struct punto3D* val1, struct punto3D* val2);
struct punto3D resta_p3D(struct punto3D p1, struct punto3D p2);
float norma_p3D(struct punto3D p);
void make_ball(float radio,float masa,struct punto3D pos,struct punto3D vel);
void LeerConf(char* archivo);
void mover(void);
void idle(void);




int GenerateT(float F)
{
	return (int)(1+F*rand()/(RAND_MAX+1.0));
}
void MakeStar(void)
{
	int rx,ry,rz;
	int i;
	for (i=0;i<=1000;i++)
	{
		while(1){
		S[i].x=GenerateT(400)-200;
		S[i].y=GenerateT(400)-200;
		S[i].z=GenerateT(400)-200;
		if ((abs(S[i].x)>=190)||(abs(S[i].y)>=190)||(abs(S[i].z)>=190)) break;
		}	
	}
}
void PaintStars(void)
{
        int i ;
        glDisable(GL_TEXTURE_2D);	
	for (i=0;i<=1000;i++)
	{
		glTranslatef(S[i].x,S[i].y,S[i].z);
		gluSphere(gQuadratic, 0.7,3,3);
	        glTranslatef(-S[i].x,-S[i].y,-S[i].z);
	}
	glEnable(GL_TEXTURE_2D);
}




/********************> main() <*****/
int		main( int argc, char **argv )
{
	if(argc==1)
	{
		printf("Uso: simul <archivo>\n");
		exit(1);
	}
	// Init GLUT
	glutInit( &argc, argv );
	glutInitDisplayMode( GLUT_DOUBLE | GLUT_RGBA | GLUT_DEPTH );
	glutInitWindowSize( 400, 300 );
	glutInitWindowPosition( 30, 50 );
	glutCreateWindow( "Simulator V1.0" );

        MakeStar();
	
	// Do custom Init stuff
	InitGL();
	LeerConf(argv[1]);
	// Set custom GLUT functions
	glutReshapeFunc( Reshape3D );
	glutDisplayFunc( DisplayGLScene );
	glutIdleFunc( idle );
	glutKeyboardFunc( Keyboard );
	glutSpecialFunc( Special );

	glutMainLoop();

	return 0;

}

/********************> InitGL() <*****/
void	InitGL( void )
{
	glClearDepth( 1.0 );
	glDepthFunc( GL_LESS );
	glEnable( GL_DEPTH_TEST );
	glShadeModel( GL_SMOOTH );
/*
	// Set up fog
	glFogi( GL_FOG_MODE, GL_EXP );
	glFogfv( GL_FOG_COLOR, gFogColor );
	glFogf( GL_FOG_DENSITY, 0.005 );
	glHint( GL_FOG_HINT, GL_FASTEST );
	glFogf( GL_FOG_START, 50 );
	glFogf( GL_FOG_END, 500 );
	//glEnable( GL_FOG );
*/
	
	// Configure a light
	glLightfv( GL_LIGHT0, GL_AMBIENT, gLightAmbient );
	glLightfv( GL_LIGHT0, GL_DIFFUSE, gLightDiffuse );
	glLightfv( GL_LIGHT0, GL_POSITION, gLightPosition );
	glLightModelf( GL_LIGHT_MODEL_TWO_SIDE, GL_TRUE );

	// Setup Material stuff
	glMaterialfv( GL_FRONT_AND_BACK, GL_AMBIENT, gMaterialAmbient );
	glMaterialfv( GL_FRONT_AND_BACK, GL_DIFFUSE, gMaterialDiffuse );
	glMaterialfv( GL_FRONT_AND_BACK, GL_SPECULAR, gMaterialSpecular );
	glMaterialf( GL_FRONT_AND_BACK, GL_SHININESS, gMaterialShininess );
	glEnable( GL_NORMALIZE );

	glEnable( GL_LIGHT0 );
	glEnable( GL_LIGHTING );

	// Set up blending
/*	
	glBlendFunc( GL_SRC_ALPHA, GL_DST_ALPHA );
	glColor4f( 1.0, 1.0, 1.0, 0.5 );
	glEnable( GL_BLEND );
 */
	// Setup a quadratic
	gQuadratic = gluNewQuadric();
	gluQuadricNormals( gQuadratic, GLU_SMOOTH );
	gluQuadricTexture( gQuadratic, GL_TRUE );


	glEnable(GL_TEXTURE_2D);
	glEnable(GL_AUTO_NORMAL);
	glEnable(GL_NORMALIZE);
	
	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LESS);	
}

/********************> Reshape3D() <*****/
void	Reshape3D( int w, int h )
{

	glViewport( 0, 0, w, h );
	glMatrixMode( GL_PROJECTION );
	glLoadIdentity();
	gluPerspective( 65.0, ( GLfloat )w / ( GLfloat )h, 0.5, 500 );
	glMatrixMode( GL_MODELVIEW );
	glLoadIdentity();
	glTranslatef( 0.0, 0.0, 0.0 );

}

/********************> DisplayGLScene() <*****/
void	DisplayGLScene( void )
{
	int i=0;
        struct bola* aux;
	aux=raiz;

	
	// Clear the screen
	glClearColor( 0.0, 0.0, 0.0, 1.0 );
	//glClearColor( 0.23, 0.35, 0.78, 1.0 );
	glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
	glLoadIdentity();

	// Move back a bit before rendering
	// primero rotar y luego trasladar, asi logro mover
	// la camara independiente
	if(camara=='l') {
	   glRotatef( gCameraRot[X], 1, 0, 0 );
	   glRotatef( gCameraRot[Y], 0, 1, 0 );
	   glRotatef( gCameraRot[Z], 0, 0, 1 );
	   glTranslatef( gCameraXPos, gCameraYPos, gCameraZPos );
	} else if(camara=='c') {
	    glLoadIdentity();
	    gluLookAt(chase->tail[lugar][0],chase->tail[lugar][1],chase->tail[lugar][2],(chase->pos).x,(chase->pos).y,(chase->pos).z,0.0,1.0,0.0);
	}
	glPushMatrix();

	// Set the rendering mode
	if ( gWireframe == GL_TRUE )
		glPolygonMode( GL_FRONT_AND_BACK, GL_LINE );
	else if ( gWireframe == GL_FALSE )
		glPolygonMode( GL_FRONT_AND_BACK, GL_FILL );

            PaintStars();

            while(aux!=NULL)
	    {	
		glPushMatrix();	
		glTranslatef((aux->pos).x,(aux->pos).y,(aux->pos).z);
		if((aux->masa)!=0.0)
		{	
		glRotatef(-90.0,1.0,0.0,0.0);	
		glRotatef(rot,0.0,0.0,1.0);
		}	
		glCallList(aux->n);	
		glPopMatrix();
		if(tail==1 && camara=='l')
		{
		   glDisable(GL_TEXTURE_2D);
		   for(i=0;i<COLA;i++) {
		      glPushMatrix();
		      glTranslatef((aux->tail[i][0]),(aux->tail[i][1]),(aux->tail[i][2]));
		      gluSphere(gQuadratic, 0.7,3,3);
		      glPopMatrix();
		   }
		   glEnable(GL_TEXTURE_2D);
		}		
	        aux=aux->sgte;	
	    }	
        rot+=2.0;
	glPopMatrix();	
	// Copy offscreen graphics buffers to the screen
	glutSwapBuffers();
	glFlush();

}


/********************> Keyboard() <*****/
void	Keyboard( unsigned char key, int x, int y )
{

	switch ( key )
	{
		//salir
		case 27:
			exit( 0 );
			break;
		// la seleccion
		case 's':
		case 'S':
			if(camara=='l')
			{
			    camara='c';
			    chase=raiz;
			    tail=0;
			}
			else
			    camara='l';
			break;
		case 'C':
		case 'c':
			gCAM = GL_TRUE;
			break;
		case 'M':
		case 'm':
			gCAM = GL_FALSE;
			break;
		case 'T':
		case 't':
			gROT = GL_FALSE;
			break;
		case 'R':
		case 'r':
			gROT = GL_TRUE;
			break;
		// ahora los movimientos
		case 'A':
		case 'a':
			if ( gCAM == GL_TRUE)
				if ( gROT == GL_TRUE )
					gCameraRot[Z] += 2;
				else
				//	if ( gCameraZPos < 85 )
						gCameraYPos -= 1;
			else
				if ( gROT == GL_TRUE )
					;//gMonoRot[Z] += 2;
				else
					//if ( gMonoZPos < 85 )
						gMonoYPos += 1;
			break;
		case 'Z':
		case 'z':
			if ( gCAM == GL_TRUE)
				if ( gROT == GL_TRUE )
					gCameraRot[Z] -= 2;
				else
				//	if ( gCameraZPos > -85 )
						gCameraYPos += 2;
			else
				if ( gROT == GL_TRUE )
					;//gMonoRot[Z] -= 2;
				else
					//if ( gMonoZPos > -85 )
						gMonoYPos -= 1;

			break;
		// si malla o no malla
		case 'W':
		case 'w':
			if ( gWireframe == GL_TRUE )
				gWireframe = GL_FALSE;
			else if ( gWireframe == GL_FALSE )
				gWireframe = GL_TRUE;
			break;
	}

}

/********************> Special() <*****/
void	Special( int key, int x, int y )
{

	switch ( key )
	{
	case GLUT_KEY_LEFT:
		if ( gCAM == GL_TRUE)
			if ( gROT == GL_TRUE )
				gCameraRot[Y] -= 2;
			else
				gCameraXPos += 1;
		else
			if ( gROT == GL_TRUE )
				gMonoRot[Y] -= 2;
			else
				gMonoXPos -= 1;
		break;

	
	case GLUT_KEY_RIGHT:
		if ( gCAM == GL_TRUE)
			if ( gROT == GL_TRUE )
				gCameraRot[Y] += 2;
			else
				gCameraXPos -= 1;
		else
			if ( gROT == GL_TRUE )
				gMonoRot[Y] += 2;
			else
				gMonoXPos += 1;
		break;

	
	case GLUT_KEY_UP:
		if ( gCAM == GL_TRUE)
			if ( gROT == GL_TRUE )
				gCameraRot[X] -= 2;
			else
				gCameraZPos += 1;
		else
			if ( gROT == GL_TRUE )
				;//gMonoRot[X] -= 2;
			else
				gMonoZPos -= 1;
		break;

	case GLUT_KEY_DOWN:
		if ( gCAM == GL_TRUE)
			if ( gROT == GL_TRUE )
				gCameraRot[X] += 2;
			else
				gCameraZPos -= 1;
		else
			if ( gROT == GL_TRUE )
				;//gMonoRot[X] += 2;
			else
				gMonoZPos += 1;
		break;
		
	case GLUT_KEY_PAGE_UP:
		if(camara=='c')
		{
			chase=chase->sgte;
			if(chase==NULL)
			    chase=raiz;
		}
		break;
	case GLUT_KEY_PAGE_DOWN:
		if(tail==0)
			tail=1;
		else
			tail=0;
		break;
	case GLUT_KEY_HOME:
		if(camara=='c'){
		   if(lugar<COLA-1)
		       lugar++;
		}
		break;
	case GLUT_KEY_END:
		if(camara=='c'){
		    if(lugar>0)
		        lugar--;
		}
		break;
	}

}
struct punto3D cp3D(float x,float y,float z)
{
	struct punto3D temp;
	temp.x=x;
	temp.y=y;
	temp.z=z;
	return temp;
}

void copiar(struct punto3D* val1, struct punto3D* val2)
{
	val1->x=val2->x;
	val1->y=val2->y;
	val1->z=val2->z;
}

struct punto3D resta_p3D(struct punto3D p1, struct punto3D p2)
{
	return cp3D(p2.x-p1.x,p2.y-p1.y,p2.z-p1.z);
}

float norma_p3D(struct punto3D p)
{
	return sqrt(p.x*p.x+p.y*p.y+p.z*p.z);
}

void make_ball(float radio,float masa,struct punto3D pos,struct punto3D vel)
{
	int i=0;
	struct bola* temp;
	struct bola* aux;
	temp=(struct bola*)malloc(sizeof(struct bola));
	temp->tex=textur;
	temp->radio=radio;
	temp->masa=masa;
	temp->sgte=NULL;
	copiar(&(temp->pos),&pos);
	copiar(&(temp->vel),&vel);
	for(i=0;i<COLA;i++) {
	      temp->tail[i][0]=(temp->pos).x;
	      temp->tail[i][1]=(temp->pos).y;
	      temp->tail[i][2]=(temp->pos).z;
	}
	temp->n = glGenLists(1);
	glNewList(temp->n, GL_COMPILE);
 	glBindTexture(GL_TEXTURE_2D, LoadGLTextures(textur));
        gluSphere(gQuadratic, radio,15,15);
	glEndList();	
	aux=raiz;
	if(aux!=NULL)
	{
		while(aux->sgte!=NULL)
			aux=aux->sgte;
		aux->sgte=temp;
	}
	else
		raiz=temp;
}

void LeerConf(char* archivo)
{
	FILE* fd1;
	int material;
	float radio,masa,posx,posy,posz;
	float velx,vely,velz;
	char* linea=(char*)malloc(255*sizeof(char));
	textur=(char*)malloc(255*sizeof(char));
	fd1=fopen(archivo,"r");
	fscanf(fd1,"%s",linea);
	while(!feof(fd1))
	{
		fscanf(fd1,"%s",textur);
		fscanf(fd1,"%f",&radio);
		fscanf(fd1,"%f",&masa);
		fscanf(fd1,"%f",&posx);
		fscanf(fd1,"%f",&posy);
		fscanf(fd1,"%f",&posz);
		fscanf(fd1,"%f",&velx);
		fscanf(fd1,"%f",&vely);
		fscanf(fd1,"%f",&velz);
		make_ball(radio,masa,cp3D(posx,posy,posz),cp3D(velx,vely,velz));
		fscanf(fd1,"%s",linea);
	}
	fclose(fd1);
}

void mover(void)
{
	int i;
	struct bola* aux;
	struct bola* temp;
	struct punto3D acel;
	struct punto3D vel;
	struct punto3D pos;
	struct punto3D res;
	double normac;
	temp=raiz;
	while(temp!=NULL)
	{
		vel=temp->vel;
		pos=temp->pos;
		acel=cp3D(0.0,0.0,0.0);
		aux=raiz;
		while(aux!=NULL && temp->masa!=0.0) {
			if(temp!=aux) {
				res=resta_p3D(temp->pos,aux->pos);
				normac=pow(norma_p3D(res),3.0);
				acel.x=acel.x+(aux->masa)*res.x/normac;
				acel.y=acel.y+(aux->masa)*res.y/normac;
				acel.z=acel.z+(aux->masa)*res.z/normac;
			}
			aux=aux->sgte;
		}
		temp->acel=acel;
		temp=temp->sgte;
	}
	temp=raiz;
	while(temp!=NULL)
	{
		vel=temp->vel;
                pos=temp->pos;
		acel=temp->acel;
		for(i=COLA-1;i>0;i--)
		{
		    temp->tail[i][0]=temp->tail[i-1][0];
		    temp->tail[i][1]=temp->tail[i-1][1];
		    temp->tail[i][2]=temp->tail[i-1][2];
		}
		temp->tail[0][0]=pos.x;
		temp->tail[0][1]=pos.y;
		temp->tail[0][2]=pos.z;
		vel.x=vel.x+acel.x*dt;
		vel.y=vel.y+acel.y*dt;
		vel.z=vel.z+acel.z*dt;
		pos.x=pos.x+vel.x*dt;
		pos.y=pos.y+vel.y*dt;
		pos.z=pos.z+vel.z*dt;
		temp->vel=vel;
		temp->pos=pos;
		temp=temp->sgte;
	}
}

void idle(void)
{
	if(t>STEP)
	{
		t=0;
		mover();
		glutPostRedisplay();
	}
	else
		t=t+1;
}
