package ezagent.place;

import ezagent.EzPlace;
import ezagent.Message;

import java.io.Serializable;
import java.util.List;
import java.util.ArrayList;

public class EzAgentBase implements Serializable
{
    public static final int CREATED = 0;
    public static final int ARRIVED = 1;

    protected EzPlace itsCurrentPlace;
    protected EzPlace itsHomePlace;
    protected String itsID;
    protected Object[] itsArgs;
    protected int itsState;
    protected List itsMessages;

    public EzAgentBase()
    {
        itsMessages = new ArrayList();
        __setState(CREATED);
    }

    public final String getId()
    {
        return itsID;
    }

    public final EzPlace getCurrentPlace()
    {
        return itsCurrentPlace;
    }

    public final EzPlace getHomePlace()
    {
        return itsHomePlace;
    }

    protected final void __setState(int state)
    {
        itsState = state;
    }

    protected final void __setCurrentPlace(EzPlace place)
    {
        itsCurrentPlace = place;
    }

    protected final void __setHomePlace(EzPlace place)
    {
        itsHomePlace = place;
    }

    protected final void __setId(String aID)
    {
        itsID = aID;
    }

    protected final void __setArgs(Object[] args)
    {
        itsArgs = args;
    }

    protected synchronized final void __addMessage(Message m)
    {
        itsMessages.add(0, m);
        notifyAll();
    }
}