package ezagent;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Set;


public interface EzPlace extends Remote
{

    public void createAgent(String clsname, Object[] args, String id) throws RemoteException;

    public void receiveAgent(EzAgent agent, String from) throws RemoteException;

    public void moveAgent(EzAgent agent, String to) throws RemoteException;

    public void moveAgent(EzAgent agent, EzPlace to) throws RemoteException;

    public void killAgent(EzAgent agent) throws RemoteException;

    public Set getAllIds() throws RemoteException;

    public boolean isHosting(String agentId) throws RemoteException;

    public boolean deliver(Message m, String agentId) throws RemoteException;

    public String getName() throws RemoteException;
}
