package example;

import ezagent.EzAgent;

import java.rmi.RemoteException;


public class VerboseAgent extends EzAgent
{
    private String[] itsPlaces;
    private int itsNextPlace = 1;

    public void onCreation(Object[] args)
    {
        System.out.println("I'm created! My name is " + getId() +
                " and my home is " + getHomePlace());

        itsPlaces = (String[]) args;

        live();
    }

    void live()
    {
        sleep();

        if (itsNextPlace >= itsPlaces.length)
        {
            goHome();
        }
        else
            moveToNext();
    }

    private void goHome()
    {
        System.out.println("I'm going home to die");
        try
        {
            move(getHomePlace());
        }
        catch (RemoteException e)
        {
            kill();
        }
    }

    private void moveToNext()
    {
        try
        {
            move(itsPlaces[itsNextPlace]);
        }
        catch (RemoteException e)
        {
            if (itsNextPlace < itsPlaces.length)
            {
                itsNextPlace++;
                moveToNext();
            }
            kill();
        }
    }

    public void onMove()
    {
        System.out.println("I'm moving");
        itsNextPlace++;
    }

    public void onArrival()
    {
        System.out.println("I'm arriving at " + getCurrentPlace());
        if (itsNextPlace > itsPlaces.length)
            kill();
        else
            live();
    }

    public void onDeath()
    {
        System.out.println("I'm dying");
    }


    private void sleep()
    {
        try
        {
            Thread.sleep(3000);
        }
        catch (InterruptedException e)
        {
            e.printStackTrace();
        }
    }
}
