package ezagent.place;

import ezagent.EzPlace;
import ezagent.Message;

import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.NotBoundException;
import java.util.ArrayList;
import java.util.List;
import java.net.MalformedURLException;


public class EzPlaces
{

    /**
     * Returns the place of the given bound in registry
     */
    public static EzPlace locate(String name)
    {
        try
        {
            EzPlace place = (EzPlace) Naming.lookup("//localhost/" + name);
            return place;
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }
        return null;
    }

    /**
     * Returns the place hosting the agent.
     */
    public static EzPlace getPlaceHosting(String aAgentID) throws RemoteException
    {
        List places = getPlaces();

        // tries to deliver message
        for (int i = 0; i < places.size(); i++)
        {
            EzPlace thePlace = (EzPlace) places.get(i);
            if (thePlace.isHosting(aAgentID))
                return thePlace;
        }
        // could not find agent
        throw new AgentNotFoundException(aAgentID);
    }

    /**
     * locates the agent and sends the message to it.
     */
    public static void deliver(Message m, String aAgentID) throws RemoteException
    {
        List places = getPlaces();

        // tries to deliver message
        for (int i = 0; i < places.size(); i++)
        {
            EzPlace thePlace = (EzPlace) places.get(i);
            if (thePlace.deliver(m, aAgentID))
                return; // delivered
        }
        // could not find agent
        throw new AgentNotFoundException(aAgentID);
    }

    /**
     * Returns all places bound in registry
     */
    private static List getPlaces()
            throws RemoteException
    {
        // get all ids of objects in registry
        String[] objectsInRegistry = new String[0];
        try
        {
            objectsInRegistry = Naming.list("//localhost/");
        }
        catch (MalformedURLException e)
        {
            e.printStackTrace();
        }

        // extract all places
        List places = new ArrayList();
        for (int i = 0; i < objectsInRegistry.length; i++)
        {
            String theName = objectsInRegistry[i];
            Object theObject = null;
            try
            {
                theObject = Naming.lookup(theName);
            }
            catch (NotBoundException e)
            {
                e.printStackTrace();
            }
            catch (MalformedURLException e)
            {
                e.printStackTrace();
            }

            if (theObject instanceof EzPlace)
                places.add(theObject);
        }
        return places;
    }
}
