package ezagent.place;

import ezagent.EzAgent;
import ezagent.EzPlace;
import ezagent.Message;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import java.util.Set;


public class EzPlaceImpl extends UnicastRemoteObject implements EzPlace
{

    /**
     * holds the ezagents present in this place.
     */
    private Hashtable itsEzAgents;

    /**
     * the name of this place. Also used to compute the ids of created ezagents.
     */
    private String itsName;


    public EzPlaceImpl() throws RemoteException
    {
        super();
        itsEzAgents = new Hashtable();
        itsName = "not_named";
    }

    public EzPlaceImpl(String name) throws RemoteException
    {
        this();
        this.itsName = name;
    }

    public void createAgent(String clsname, Object[] args, String id) throws RemoteException
    {
        Class cls = null;

        try
        {
            cls = Class.forName(clsname);
        }
        catch (ClassNotFoundException e)
        {
            throw new RemoteException("could not find class", e);
        }

        EzAgent agent = null;

        agent = instantiateAgent(id, args, cls);

        launchAgent(agent);
        System.out.println("[System] agent " + id + " created");
    }

    private EzAgent instantiateAgent(String id, Object[] args, Class cls)
    {

        EzAgent agent = null;
        try
        {
            agent = (EzAgent) cls.newInstance();
            agent.__setId(id);
            agent.__setHomePlace(this);
            agent.__setCurrentPlace(this);
            agent.__setArgs(args);
            return agent;

        }
        catch (InstantiationException e)
        {
            e.printStackTrace();
        }
        catch (IllegalAccessException e)
        {
            e.printStackTrace();
        }
        return null;
    }

    public synchronized void receiveAgent(EzAgent agent, String from)
            throws RemoteException
    {
        agent.__setState(EzAgent.ARRIVED);
        agent.__setCurrentPlace(this);

        launchAgent(agent);
        System.out.println("[System] agent " + agent.getId() + " received");
    }

    protected synchronized void launchAgent(EzAgent agent) throws RemoteException
    {
        if(isHosting(agent.getId()))
            throw new AgentIDConflictException(agent.getId());
        
        itsEzAgents.put(agent.getId(), agent);
        startAgent(agent);
    }

    public synchronized void moveAgent(EzAgent agent, String to) throws RemoteException
    {
        EzPlace destination = EzPlaces.locate(to);
        moveAgent(agent, destination);
    }

    public synchronized void moveAgent(EzAgent agent, EzPlace to) throws RemoteException
    {
        String id = agent.getId();

        if (isHosting(id))
        {
            itsEzAgents.remove(id);
            to.receiveAgent(agent, itsName);
            throw new AgentMovedException(id, to.getName());
        }
        else
            throw new RemoteException("Agent not found");
    }

    public synchronized void killAgent(EzAgent agent) throws RemoteException
    {
        String id = agent.getId();

        if (isHosting(id))
        {
            itsEzAgents.remove(id);
            throw new AgentDisposedException(id);
        }
        else
            throw new RemoteException("Agent not found");
    }

    public synchronized Set getAllIds() throws RemoteException
    {
        return itsEzAgents.keySet();
    }

    public boolean isHosting(String agentId) throws RemoteException
    {
        return getAgent(agentId) != null;
    }

    public synchronized EzAgent getAgent(String id)
    {
        return (EzAgent) itsEzAgents.get(id);
    }

    /**
     * If this place hosts the given agent, delivers the message.
     */
    public boolean deliver(Message m, String agentId) throws RemoteException
    {
        EzAgent agent = getAgent(agentId);
        if (agent == null) return false;
        agent.__addMessage(m);
        return true;
    }

    /**
     * Sends the message to the agent, first finding where it is located
     */
    public void sendTo(Message m, String agentId) throws RemoteException
    {
        if (!deliver(m, agentId))
            EzPlaces.deliver(m, agentId);
    }

    public String getName() throws RemoteException
    {
        return itsName;
    }

    protected void startAgent(EzAgent agent)
    {
        EzAgentRunner ar = new EzAgentRunner(agent);
        ar.start();
    }

    public String toString()
    {
        return itsName;
    }

    public boolean equals(Object o)
    {
        try
        {
            return ((EzPlace) o).getName().equals(itsName);
        }
        catch (RemoteException e)
        {
            e.printStackTrace();
            return false;
        }
    }
}
