package ezagent;

import ezagent.place.EzAgentBase;
import ezagent.place.EzPlaceImpl;

import java.rmi.RemoteException;


public abstract class EzAgent extends EzAgentBase implements Runnable
{

    // --------------- LIFE CYCLE METHODS TO BE DEFINED IN SUBCLASSES -----------------//
    public abstract void onCreation(Object[] args);

    public void onMove()
    {
    }

    public void onArrival()
    {
    }

    public void onDeath()
    {
    }
    // --------------- END LIFE CYCLE METHODS -----------------//


    public final void run()
    {
        switch (itsState)
        {
            case CREATED:
                onCreation(itsArgs);
                break;
            case ARRIVED:
                onArrival();
                break;
        }
    }

    public final void move(String placename) throws RemoteException
    {
        onMove();
        itsCurrentPlace.moveAgent(this, placename);
    }

    public final void move(EzPlace place) throws RemoteException
    {
        onMove();
        itsCurrentPlace.moveAgent(this, place);
    }

    protected final void kill()
    {
        try
        {
            onDeath();
            itsCurrentPlace.killAgent(this);
        }
        catch (RemoteException e)
        {
        }
    }

    protected final void send(Message m, String to) throws RemoteException
    {
        m.setSender(getId());
        ((EzPlaceImpl)itsCurrentPlace).sendTo(m, to);
    }

    /**
     * returns the next message to process - if none, this method <b>blocks</b>
     * until a message is received.
     */
    protected synchronized final Message waitMessage()
    {
        try
        {
            while (!hasMessage())
                wait();

            return getNextMessage();
        }
        catch (InterruptedException e)
        {
            e.printStackTrace();
            return null;
        }
    }

    /**
     * Returns the next message to process, or null if none.
     */
    protected synchronized final Message getNextMessage()
    {
        if (!hasMessage()) return null;
        return (Message) itsMessages.remove(itsMessages.size()-1);
    }

    /**
     * Returns true if has a message to be processed
     */
    protected synchronized final boolean hasMessage()
    {
        return itsMessages.size() != 0;
    }
}
