package chat;

import java.rmi.server.UnicastRemoteObject;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class ChatRoomImpl extends UnicastRemoteObject
    implements ChatRoom {

    private List itsClients;

    public ChatRoomImpl() throws RemoteException {
        itsClients = new ArrayList();
    }

    public void join(ChatClient c) throws RemoteException {
        itsClients.add(c);
        System.out.println("Client " + c.getName() + " joined the room.");
    }

    public void leave(ChatClient c) throws RemoteException {
        itsClients.remove(c);
        System.out.println("Client " + c.getName() + " left the room.");
    }

    public void postMessage(ChatClient c, String message) throws RemoteException {
        String from = c.getName();
        for (int i = 0; i < itsClients.size(); i++) {
            ChatClient chatClient = (ChatClient) itsClients.get(i);
            chatClient.newMessage(from, message);
        }
    }
}
