package chat;

import java.rmi.Naming;

public class ClientApp {

    /**
     * arg[0] is client name
     * arg[1] is server address
     * arg[2] is chat room name
     */
    public static void main(String[] args) throws Throwable {
        ChatClient client = new ChatClientImpl(args[0]);

        ChatRoom room = (ChatRoom) Naming.lookup(args[1] + "/" + args[2]);

        room.join(client);

        // simulate activity
        room.postMessage(client, "hello world");
        Thread.sleep(5000);
        room.postMessage(client, "very nice demo!");
        Thread.sleep(5000);
        room.postMessage(client, "bye!");
        Thread.sleep(5000);
        room.leave(client);
    }
}
