#!/usr/bin/env ruby

require 'json'
require 'optparse'
require "#{ENV['CODE_HOME']}/ruby/endpoint.rb"

BANNER = <<-EOS
Usage: run_bench_low [options] <eng> <q> <sf> <br>

- eng : The engine name: 'virtuoso' or 'fuseki'.
- q   : A pattern matching query files, e.g., 'queries/low/*.sparql'.
- sf  : A range or array for scale factors, e.g., '1..5' or '[1,3]'.
- br  : A range for blank rates, e.g., '1..4' or '[1,2,4,8]'.
EOS

options = {}
OptionParser.new do |opts|
  opts.banner = BANNER
end.parse!

unless ARGV.size == 4
  STDERR.puts BANNER
  exit 1
end

# Parsing ARGV[0] : Engine
ENGINE = ARGV[0]
case ENGINE
when 'virtuoso'
  SERVICE = VirtuosoEndpoint.new
when 'fuseki'
  SERVICE = FusekiEndpoint.new
else
  STDERR.puts "Unsupported engine: #{ARGV[0]}"
  exit 1
end

# Parsing ARGV[1] : Queries
QUERIES = Dir[ARGV[1]].to_a.sort
if QUERIES.empty?
  STDERR.puts "There are no query files on: #{ARGV[1]}"
end

# Parsing ARGV[2] and ARGV[3] : sf and br
SF_RANGE = read_range(ARGV[2])
BR_RANGE = read_range(ARGV[3])

SF_RANGE.each do |sf|
  BR_RANGE.each do |br|
    QUERIES.each do |q|
      name  = "ds-fs#{'%06i' % (sf*10000)}-br#{'%03i' % br}"
      qname = "#{name}-#{File.basename(q).sub(/.sparql$/,'')}"
      dbdir = "#{ENV['DB_DIR']}/low/#{ENGINE}/#{name}"  # TODO: fuseki must be a parameter
      STDERR.puts qname

      system "sync; echo 3 > sudo /proc/sys/vm/drop_caches"
      SERVICE.start(dbdir)
      [ "SELECT (count(*) as ?c) " +
        "WHERE { SELECT DISTINCT ?s WHERE { ?s ?p ?o } }",
        "SELECT (count(*) as ?c) " +
        "WHERE { SELECT DISTINCT ?p WHERE { ?s ?p ?o } }",
        "SELECT (count(*) as ?c) " +
        "WHERE { SELECT DISTINCT ?o WHERE { ?s ?p ?o } }" ].each do |warmup|
        run_query(SERVICE.endpoint, warmup, 18300)
      end
      File.open("#{ENV['OUTPUT_DIR']}/low/#{ENGINE}/#{qname}.json", 'w') do |file|
        query = File.new(q).read
        results = run_query_until_success(SERVICE.endpoint, query, 18300)
        results.delete 'body' unless results['doc'].nil?
        file.puts [results].to_json
        sleep 5
      end
      SERVICE.stop
    end
  end
end
