#!/usr/bin/env ruby

require 'json'

BANNER = 'Usage: csv_serie.rb <dir> <timeout>'

unless ARGV.size == 2
  STDERR.puts BANNER
  exit 1
end

DIRECTORY = ARGV[0]
TIMEOUT   = ARGV[1].to_i

# Dir["#{DIRECTORY}/ds-sf*-br*-*.json"].each do |filename|
#   STDERR.puts filename
#   File.open(filename + 'fix', 'w') do |out|
#     out.puts "[#{File.new(filename).read.strip}]"
#   end
# end

groups = {}
Dir["#{DIRECTORY}/ds-sf*-br*-*.json"].sort.each do |filename|
  puts "Reading #{filename}"
  s = File.basename(filename).sub(/^ds-/,'').sub(/.json$/,'').split('-')
  doc = JSON.parse(File.new(filename).read.sub(/,\s*\]/,']'))
  sum = 0.0
  doc.each do |item|
    time = (item['time'] < TIMEOUT) ? item['time'] : TIMEOUT
    sum += time
  end
  avg = sum / doc.size

  # group by blank rate and query
  groups[[s[1], s[2]]] = [] unless groups.include?([s[1], s[2]])
  groups[[s[1], s[2]]] << [s[0].sub(/^sf/,'').to_i, avg]
end

groups.each do |k,v|
  File.open("#{DIRECTORY}/#{k.join('-')}.tsv", 'w') do |out|
    out.puts "# #{k.join('-')}"
    v.each { |pair| out.puts pair.join("\t")  }
  end
end
