#!/usr/bin/env ruby

require "./endpoint.rb"

if ARGV.size != 2
  STDERR.puts "Usage: load_virtuoso.rb <sf> <br>"
  exit 1
end

SF_RANGE = read_range(ARGV[0])
BR_RANGE = read_range(ARGV[1])

SF_RANGE.each do |sf|
  BR_RANGE.each do |br|
    STDERR.puts "Loading data into Virtuoso (sf=#{sf} br=#{br*0.01})"
    name     = "sf#{'%03i' % sf}-br#{'%03i' % br}"
    datafile = Dir["#{ENV['DATA_DIR_TPCH']}/**/*-#{name}.ttl.gz"].to_a.join(' ')
    dbdir    = "#{ENV['DB_DIR']}/tpch/virtuoso/#{name}"
    dbtarget = "#{ENV['VIRTUOSO_HOME']}/var/lib/virtuoso/db"

    # setup an empty database directory
    unless File.directory? "#{ENV['DB_DIR']}/tpch/virtuoso"
      STDERR.puts "Directory do not exists: #{ENV['DB_DIR']}/tpch/virtuoso"
      exit 1
    end
    if File.exists? dbdir
      STDERR.puts "Directory already exists: #{dbdir}"
      exit 1
    end
    system "mkdir #{dbdir}"
    system "ln -s #{ENV['VIRTUOSO_INI']} #{dbdir}/virtuoso.ini"
    system "rm #{dbtarget}" if File.exists? dbtarget
    system "ln -s #{dbdir} #{dbtarget}"

    # load the data in the endpoint
    endpoint = VirtuosoEndpoint.new
    endpoint.start(dbdir)
    endpoint.load(datafile)
    endpoint.stop
  end
end
