#!/usr/bin/env ruby

require "./endpoint.rb"

if ARGV.size != 2
  STDERR.puts "Usage: load_virtuoso_low.rb <sf> <br>"
  exit 1
end

SF_RANGE = read_range(ARGV[0])
BR_RANGE = read_range(ARGV[1])

SF_RANGE.each do |sf|
  BR_RANGE.each do |br|
    STDERR.puts "Loading data into Virtuoso (sf=#{sf} br=#{br*0.01})"
    name     = "ds-sf#{'%06i' % (sf*10000)}-br#{'%03i' % br}"
    datafile = "#{ENV['DATA_DIR_LOW']}/#{name}.ttl.gz"
    dbtarget = "#{ENV['VIRTUOSO_HOME']}/var/lib/virtuoso/db"

    # setup an empty database directory
    unless File.directory? "#{ENV['DB_DIR']}/low/virtuoso"
      STDERR.puts "Directory do not exists: #{ENV['DB_DIR']}/low/virtuoso"
      exit 1
    end
    dbdir = "#{ENV['DB_DIR']}/low/virtuoso/#{name}"
    if File.exists? dbdir
      STDERR.puts "Directory already exists: #{dbdir}"
      exit 1
    end
    system "mkdir #{dbdir}"
    system "ln -s #{ENV['VIRTUOSO_INI']} #{dbdir}/virtuoso.ini"
    system "rm #{dbtarget}" if File.exists? dbtarget
    system "ln -s #{dbdir} #{dbtarget}"

    # load the data in the endpoint
    endpoint = VirtuosoEndpoint.new
    endpoint.start(dbdir)
    endpoint.load(datafile)
    endpoint.stop
  end
end
