#!/usr/bin/env ruby

if ARGV.size != 2
  STDERR.puts "Usage: load_fuseki_low.rb <sf> <br>"
  exit 1
end

SF_RANGE = read_range(ARGV[0])
BR_RANGE = read_range(ARGV[1])

SF_RANGE.each do |sf|
  BR_RANGE.each do |br|
    STDERR.puts "Loading data into Fuseki (sf=#{sf} br=#{br*0.01})"
    name     = "sf#{'%03i' % sf}-br#{'%03i' % br}"
    datafile = Dir["#{ENV['DATA_DIR_TPCH']}/**/*-#{name}.ttl.gz"].to_a.join(' ')
    dbdir    = "#{ENV['DB_DIR']}/#{MODEL}/fuseki/#{name}"

    # load the data
    system "#{ENV['JENA_HOME']}/bin/tdbloader2 --loc #{dbdir} #{datafile}"
  end
end
