#include <stdio.h>
#include <stdlib.h>
#define __USE_XOPEN

#define X 1
#define Y 2
#define DRAND ((double)rand() / (double)RAND_MAX)
#define VOC "http://example.org/"

int scale_factor      = 1;
double blank_rate     = 0;
int maxsize           = 1;

/* Generate and print a value for attribute Z randomnly. */
void attr_z(int sf, double br, int maxsize)
{
    int i, j, k, d, p[100];
    
    if(DRAND < br) {
        printf("[ a :Blank ; :maybeSameAs ");
        
        k = rand() % maxsize + 2;
        
        for(i=0; i < k;) {
            d = 1;
            p[i] = rand() % sf;
            for(j=0; j < i; ++j)
                if(p[i] == p[j]) d = 0;
            if (d) i++;
        }
        
        for(i=0; i < k-1; ++i)
            printf(":Z%i , ", p[i]);
        printf(":Z%i ] .\n", p[k-1]);
    } else {
        printf(":Z%i .\n", rand() % sf);
    }
}

int main(int argc, char *argv[])
{
    int i;
    
    /* ensure that args exists */
    if (argc != 4) {
        fprintf(stderr, "Usage: dbgen <scale factor> <blank rate> <maxsize>\n");
        exit(1);
    }
    
    scale_factor = atoi(argv[1]);
    blank_rate   = atof(argv[2]);
    maxsize      = atoi(argv[3]);
    
    fprintf(stderr, "Low level dataset (variant)\n");
    fprintf(stderr, "Scale factor:      %i\n", scale_factor);
    fprintf(stderr, "Blank rate:        %f\n", blank_rate);
    fprintf(stderr, "Maximum set size:  %i\n", maxsize);
    
    printf("# Low level dataset (variant)\n");
    printf("# Scale factor:       %i\n", scale_factor);
    printf("# Blank rate:         %f\n", blank_rate);
    printf("# Maximum set size:   %i\n\n", maxsize);
    
    printf("@prefix : <%s> .\n\n", VOC);
    
    for (i=0; i < scale_factor; i++) {
        printf(":X%i a :X ; :xz ", i);
        attr_z(scale_factor, blank_rate, maxsize);
        printf(":Y%i a :Y ; :yz ", i);
        attr_z(scale_factor, blank_rate, maxsize);      
        printf(":Z%i a :Z .\n", i);
    }
    
    return 0;
}
