#!/usr/bin/env ruby

if ARGV.size != 2
  STDERR.puts "Usage: ./dbgen.rb <scale factor> <blank rate>"
  exit 1
end

# Read a range or an array of items
def read_items(items)
  begin
    r = eval(items)
    unless Range === r or Array === r
      puts "Not range or array: #{items}"
      exit 1
    end
  rescue SyntaxError => se
    puts "Format not valid: #{items}"
    exit 1
  end
  r
end

read_items(ARGV[0]).each do |sf|
  read_items(ARGV[1]).each do |br|
    p_sf = '%06i' % (sf*10000)
    p_br = '%03i' % br
    
    datafile = "#{ENV['DATA_DIR']}/ds-sf#{p_sf}-br#{p_br}.ttl.gz"
    STDERR.puts "Generating #{datafile}"
    system "dbgen #{sf*10000} #{br*0.01} | gzip > #{datafile}"
    
    datafile = "#{ENV['DATA_DIR_VARIANT']}/ds-sf#{p_sf}-br#{p_br}.ttl.gz"
    STDERR.puts "Generating #{datafile}"
    system "dbgen_variant #{sf*10000} #{br*0.01} | gzip > #{datafile}"
  end
end
