#include <stdio.h>
#include <stdlib.h>
#define __USE_XOPEN

#define X 1
#define Y 2
#define DRAND ((double)rand() / (double)RAND_MAX)
#define VOC "http://example.org/"

int scale_factor      = 1;
double blank_rate     = 0;

/* Generate and print a value for attribute Z randomnly. */
void attr_z(int sf, double br) {
    if(DRAND < br)
        printf("[ a :Blank ]");
    else
        printf(":Z%i", rand() % sf);
}

/* Print generated data in Turtle format. */
int main(int argc, char *argv[])
{
    int i;
    
    if (argc != 3) {
        fprintf(stderr, "Usage: dbgen <scale factor> <blank rate>\n");
        exit(1);
    }
    
    scale_factor = atoi(argv[1]);
    blank_rate   = atof(argv[2]);
    
    fprintf(stderr, "Low level dataset\n");
    fprintf(stderr, "Scale factor:      %i\n", scale_factor);
    fprintf(stderr, "Blank rate:        %f\n", blank_rate);
    
    printf("# Low level dataset\n");
    printf("# Scale factor:       %i\n", scale_factor);
    printf("# Blank rate:         %f\n", blank_rate);
    
    printf("@prefix : <%s> .\n\n", VOC);
    
    for (i=0; i < scale_factor; i++)
    {
        printf(":X%i a :X ; :xz ", i);
        attr_z(scale_factor, blank_rate);
        printf(" .\n");
        
        printf(":Y%i a :Y ; :yz ", i);
        attr_z(scale_factor, blank_rate);
        printf(" .\n");
        
        printf(":Z%i a :Z .\n", i);
    }
    
    return 0;
}
