
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#if 1
 #include <sys/timeb.h>
#else
 #include <sys/time.h>
 #include <sys/resource.h>
#endif
#include "comparray4.h"

int MEM=0; // GZL
int reportLevel = 2;
#include <sys/times.h>
#include <unistd.h>
struct tms time1,time2;
double ticks;

#ifndef min
#define min(x,y) ((x)<(y)?(x):(y))
#endif

#if 1
typedef struct timeb mytimestruct;
void mygettime(mytimestruct *t)
{
  ftime(t);
}
double mylaptime(mytimestruct *before,mytimestruct *after)
{
  double t;
  t = after->time - before->time;
  t += (double)(after->millitm - before->millitm)/1000;
  return t;
}
#else
typedef mytimestruct struct rusage;
void mygettime(mytimestruct *t)
{
  getrusage(RUSAGE_SELF,t);
}
double mylaptime(mytimestruct *before,mytimestruct *after)
{
  double t;
  t = after->ru_utime.tv_sec - before->ru_utime.tv_sec;
  t += (double)(after->ru_utime.tv_usec
		- before->ru_utime.tv_usec)/1000000;
  return t;
}
#endif

int main(int argc, char *argv[])
{
  int i,n;
  CSA SA;
  mytimestruct before,after;
  double t;
  char fname1[128],fname2[128];

   if (argc<2) {
      fprintf(stderr, "syntax: suftest file\n");
      return 1;
   }

   initranktables();
   mkdecodetable();

#if 0
   {
     FILE *f;
     unsigned char buf[1024];
     mygettime(&before);
     sprintf(fname1,"%s.psi",argv[1]);
     f = fopen(fname1,"rb");
     while (!feof(f)) {
       fread(buf,1024,1,f);
     }
     fclose(f);
     mygettime(&after);
     t = mylaptime(&before,&after);
     printf("fread %f sec\n",t);
   }
#endif
   sprintf(fname1,"%s.psi",argv[1]);
   sprintf(fname2,"%s.idx",argv[1]);
   if (argc>=3) sprintf(fname2,"%s",argv[2]);
   csa_read(&SA,fname1,fname2);
   n = SA.n;
printf ("MEM=%i\n",MEM); //GZL

#if 0
   {
     int j;
     mygettime(&before);
     i = csa_inverse(&SA,1);
     for (j=0; j<100000; j++) {
       i = csa_psi(&SA,i);
       if (j % 1000 == 0) printf("%d ",j);
     }
     mygettime(&after);
     t = mylaptime(&before,&after);
     printf("psi %f sec\n",t);
   }
#endif
#if 0
   {
     mygettime(&before);
     csa_checknumio(&SA,10000);
     csa_checknumio(&SA,20000);
     csa_checknumio(&SA,40000);
     csa_checknumio(&SA,80000);
     //csa_checkfreq(&SA);
     mygettime(&after);
     t = mylaptime(&before,&after);
     printf("checkfreq %f sec\n",t);
   }
#endif
#if 0
   {
     unsigned char *buf;
     FILE *out;
     sprintf(fname1,"%s.out",argv[1]);
     out = fopen(fname1,"wb");
     buf = malloc(n+1);
     if (buf==NULL) {perror("buf");  exit(1);}
     mygettime(&before);
     csa_decodeall(buf,&SA);
     mygettime(&after);
     t = mylaptime(&before,&after);
     printf("decodeall %f sec\n",t);
     fwrite(buf,1,n,out);
     free(buf);
     fclose(out);
     exit(0);
   }
#endif

#if 0
   {
     unsigned char *buf;
     FILE *out;
     sprintf(fname1,"%s.out",argv[1]);
     out = fopen(fname1,"wb");
     buf = malloc(n+1);
     if (buf==NULL) {perror("buf");  exit(1);}
     mygettime(&before);
     csa_decodeall2(buf,&SA);
     mygettime(&after);
     t = mylaptime(&before,&after);
     printf("decodeall2 %f sec\n",t);
     fwrite(buf,1,n,out);
     free(buf);
     fclose(out);
     //exit(0);
   }
#endif

#if 0
   {
     int j,l,r,len;
     int *I,*I2;
     unsigned char key[256];
     mygettime(&before);
     for (j=0; j<100; j++) {
       printf("%d ",j);
       l = rand() % (n-200) + 1;
       csa_decode2(key,&SA,l,200);
       //len = csa_bsearch(key,200,&SA,&l,&r);
     }
     mygettime(&after);
     t = mylaptime(&before,&after);
     printf("search %f sec\n",t);
     exit(0);
   }
#endif

#if 0
   {
     int j,l,r,len;
     int *I,*I2;
     unsigned char key[256];
     for (j=0; j<100; j++) {
       l = rand() % (n-200) + 1;
       mygettime(&before);
       csa_decode2(key,&SA,l,200);
       mygettime(&after);
       t = mylaptime(&before,&after);
       printf("decode %f sec ",t);
       mygettime(&before);
       len = csa_bsearch(key,200,&SA,&l,&r);
       mygettime(&after);
       t = mylaptime(&before,&after);
       printf("ans %d [%d %d]\ ",r-l+1,l,r);
       printf("search %f sec\n",t);
     }
   }
#endif

#if 1
   {
     int j,l,r,len;
     int *I,*I2;
     unsigned char key[256];
     unsigned char key2[256];
     
     ticks= (double)sysconf(_SC_CLK_TCK);
     times(&time1);

     while (1) {
       printf("\ninput key ");  fflush(stdout);
       j=0; while ((key[j]=getchar())!='\n') j++;
       key[j] = 0;
       if (!strcmp(key,"END")) break;
       len = csa_bsearch(key,strlen(key),&SA,&l,&r);
       printf("ans %d [%d %d]\n",r-l+1,l,r);
       if (reportLevel > 0) {
	 I = csa_batchlookup3(&SA,l,r);
       }
     }
     times (&time2);
     fprintf (stderr,"Query time: %f\n",(time2.tms_utime - time1.tms_utime)/ticks);
       exit(1);
   }
#endif

#if 1
   mygettime(&before);
   for (i = 1; i <= n; i++) {
     int j,psi;
     j = i;
     psi = csa_psi(&SA,i);
   }
   mygettime(&after);
   t = mylaptime(&before,&after);
   printf("psi %f sec\n",t);
#endif
#if 1
   mygettime(&before);
   for (i = 1; i <= n; i++) {
     int c;
     c = csa_T(&SA,i);
   }
   mygettime(&after);
   t = mylaptime(&before,&after);
   printf("T %f sec\n",t);
#endif
#if 1
   {
     unsigned char *buf;
     buf = malloc((n+1)*sizeof(*buf));
     if (buf==NULL) {printf("malloc buf\n"); exit(1);}
     mygettime(&before);
     csa_decode(buf,&SA,1,n);
     mygettime(&after);
     free(buf);
   }
   t = mylaptime(&before,&after);
   printf("decode %f sec\n",t);
#endif
#if 1
   mygettime(&before);
   for (i = 1; i <= n; i++) {
     int idx;
     idx = csa_lookup(&SA,i);
     if (i % 100 == 0) {
       printf("%d\r",i);
       fflush(stdout);
     }
   }
   mygettime(&after);
   t = mylaptime(&before,&after);
   printf("lookup %f sec\n",t);
#endif
#if 1
   mygettime(&before);
   for (i = 1; i <= n/10; i++) {
     int j;
     if (i % 100 == 0) {
       printf("%d\r",i);
       fflush(stdout);
     }
     j = csa_inverse(&SA,i);
   }
   mygettime(&after);
   t = mylaptime(&before,&after);
   printf("inverse %f sec\n",t);
#endif

#ifdef USE_MMAP
   mymunmap(SA.mapp);
   mymunmap(SA.mapi);
#endif

   return 0;
}
