/* compressed suffix arrays 

 */

#ifndef _COMPARRAY_H_
#define _COMPARRAY_H_

// GZL #define USE_MMAP

#ifdef USE_MMAP
#include "mman.h"
#endif

#ifndef min
#define min(x,y) ((x)<(y)?(x):(y))
#endif

#define ENCODENUM encodegamma
#define DECODENUM decodegamma
#define TWO rankb_w
#define TWO2 (TWO*16)
#define PSIL rankb_w2

#define SIGMA 256

typedef struct csa {
  int n; /* length of the text */
  int m; /* the number of distinct characters in the text */
  int l; /* interval between two psi values stored explicitly */
  int two; /* interval between two SA values stored explicitly */
  int two2; /* interval between two inverse SA values stored explicitly */
  int K[SIGMA+2]; /* table of cumulative frequency */
  int C[SIGMA+1]; /* table to convert character code to cumulative frequency */
  int C2[SIGMA+1]; /* table of character codes */
  int *SA,*ISA,*R;
  unsigned short *B; /* pointer to the bit stream encoding psi */
#ifdef USE_MMAP
  MMAP *mapp,*mapi;
#endif
} CSA;

/* calculate SA[i] */
int csa_lookup(CSA *SA, int i);

/* calculate Psi[i] */
int csa_psi(CSA *SA,int i);

/* search for "key" of length "kenlen"
   Return value represents the length of the longest prefix of "key"
   that appears in the text. This function also returns an interval [li,ri]
   of the suffix array which corresponds to "key."

/* calculate SA[l..r] into an array and return its pointer */
int *csa_batchlookup(CSA *SA,int l, int r);

/* calculate SA^{-1}[i] */
int csa_inverse(CSA *SA, int suf);

/* decode T[suf..suf+len-1] into p */
void csa_decode(unsigned char *p,CSA *SA,int suf,int len);

/* decode T[SA[pos]..SA[pos]+len-1] into p */
void csa_decode2(unsigned char *p,CSA *SA,int pos,int len);

int csa_T(CSA *SA,int i);
int csa_write(CSA *SA,char *fname1,char *fname2);
void csa_new(int n, int *p, unsigned char *s, char *fname1, char *fname2);
int csa_read(CSA *SA,char *fname1,char *fname2);
int initranktables(void);
void mkdecodetable(void);

int *csa_batchlookup2(CSA *SA,int l, int r);
int *csa_batchlookup3(CSA *SA,int l, int r);
int *csa_batchlookup4(CSA *SA,int l, int r);

int csa_bsearch(unsigned char *key,int keylen,CSA *SA,int *li,int *ri);
void csa_decode1line(CSA *SA,int suf);
void csa_decodeall(unsigned char *p,CSA *SA);
void csa_decodeall2(unsigned char *p,CSA *SA);
void csa_checknumio(CSA *SA,int B);
void csa_checkfreq(CSA *SA);
void csa_newidx(CSA *SA,char *fname,int T,int L);


#endif
