#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#if 1
 #include <sys/timeb.h>
#else
 #include <sys/time.h>
 #include <sys/resource.h>
#endif
#include "comparray4.h"

#ifndef min
#define min(x,y) ((x)<(y)?(x):(y))
#endif

#if 1
typedef struct timeb mytimestruct;
void mygettime(mytimestruct *t)
{
  ftime(t);
}
double mylaptime(mytimestruct *before,mytimestruct *after)
{
  double t;
  t = after->time - before->time;
  t += (double)(after->millitm - before->millitm)/1000;
  return t;
}
#else
typedef mytimestruct struct rusage;
void mygettime(mytimestruct *t)
{
  getrusage(RUSAGE_SELF,t);
}
double mylaptime(mytimestruct *before,mytimestruct *after)
{
  double t;
  t = after->ru_utime.tv_sec - before->ru_utime.tv_sec;
  t += (double)(after->ru_utime.tv_usec
		- before->ru_utime.tv_usec)/1000000;
  return t;
}
#endif

int main(int argc, char *argv[])
{
  int i,n;
  CSA SA;
  mytimestruct before,after;
  double t;
  char fname1[128],fname2[128];

   if (argc<2) {
      fprintf(stderr, "syntax: suftest file\n");
      return 1;
   }

   initranktables();
   mkdecodetable();

   sprintf(fname1,"%s.psi",argv[1]);
   sprintf(fname2,"%s.idx",argv[1]);
   csa_read(&SA,fname1,fname2);
   n = SA.n;

#if 1
   {
     unsigned char *buf;
     FILE *out;
     sprintf(fname1,"%s.out",argv[1]);
     out = fopen(fname1,"wb");
     buf = malloc(n+1);
     if (buf==NULL) {perror("buf");  exit(1);}
     csa_decodeall(buf,&SA);
     fwrite(buf,1,n,out);
     free(buf);
     fclose(out);
     //exit(0);
   }
#endif

#if 1
   {
     int j,l,r,len;
     int *I,*I2;
     unsigned char key[128];
     unsigned char key2[128];
     while (!feof(stdin)) {
       printf("\ninput key ");  fflush(stdout);
       scanf("%s",key);
       mygettime(&before);
       len = csa_bsearch(key,strlen(key),&SA,&l,&r);
       mygettime(&after);
       t = mylaptime(&before,&after);
       printf("ans %d [%d %d]\n",r-l+1,l,r);
       printf("search %f sec\n",t);
       if (r-l<1000) {
	 mygettime(&before);
	 I = csa_batchlookup(&SA,l,r);
	 mygettime(&after);
	 t = mylaptime(&before,&after);
	 printf("lookup %f sec\n",t);
#if 0
	 mygettime(&before);
	 I2 = csa_batchlookup2(&SA,l,r);
	 mygettime(&after);
	 t = mylaptime(&before,&after);
	 printf("batchlookup2 %f sec\n",t);
	 for (j=0; j<r-l+1; j++) {
	   if (I[1+j] != I2[1+j]) {
	     printf("error %d %d!=%d\n",l+j,I[1+j],I2[1+j]);
	   }
	 }
	 printf("[");
	 for (j=0; j<r-l+1; j++) {
	   //printf("%d ",I[1+j]);
	 }
	 printf("]\n");
	 free(I2);
#endif
	 for (j = 1; j <= min(r-l+1,10); j++) {
	   unsigned char tmp[80+1];
	   csa_decode1line(tmp,&SA,I[j],80);
	   printf("%10d %s\n",I[j],tmp);
	 }
	 free(I);
       }
#if 1
       if (l <= r) {
	 printf("%c %c\n",csa_T(&SA,l),csa_T(&SA,r));
	 //csa_decode(key2,&SA,csa_lookup(&SA,l),strlen(key));
	 csa_decode2(key2,&SA,l,strlen(key));
	 key2[strlen(key)] = 0;
	 if (strcmp(key,key2)!=0) {
	   printf("error key %s != %s\n",key,key2);
	 } else {
	   printf("key %s == %s\n",key,key2);
	 }
	 //csa_decode(key2,&SA,csa_lookup(&SA,r),strlen(key));
	 csa_decode2(key2,&SA,r,strlen(key));
	 key2[strlen(key)] = 0;
	 if (strcmp(key,key2)!=0) {
	   printf("error key %s != %s\n",key,key2);
	 } else {
	   printf("key %s == %s\n",key,key2);
	 }
       } else {
	 printf("No match was found. The longest match length is %d.\n",len);
       }
#endif
     }
   }
#endif


#if 1
   mygettime(&before);
   for (i = 1; i <= n; i++) {
     int j,psi;
     j = i;
     psi = csa_psi(&SA,i);
   }
   mygettime(&after);
   t = mylaptime(&before,&after);
   printf("psi %f sec\n",t);
#endif
#if 1
   mygettime(&before);
   for (i = 1; i <= n; i++) {
     int c;
     c = csa_T(&SA,i);
   }
   mygettime(&after);
   t = mylaptime(&before,&after);
   printf("T %f sec\n",t);
#endif
#if 1
   {
     unsigned char *buf;
     buf = malloc((n+1)*sizeof(*buf));
     if (buf==NULL) {printf("malloc buf\n"); exit(1);}
     mygettime(&before);
     csa_decode(buf,&SA,1,n);
     mygettime(&after);
     free(buf);
   }
   t = mylaptime(&before,&after);
   printf("decode %f sec\n",t);
#endif
#if 1
   mygettime(&before);
   for (i = 1; i <= n; i++) {
     int idx;
     idx = csa_lookup(&SA,i);
     if (i % 100 == 0) {
       printf("%d\r",i);
       fflush(stdout);
     }
   }
   mygettime(&after);
   t = mylaptime(&before,&after);
   printf("lookup %f sec\n",t);
#endif
#if 1
   mygettime(&before);
   for (i = 1; i <= n/10; i++) {
     int j;
     if (i % 100 == 0) {
       printf("%d\r",i);
       fflush(stdout);
     }
     j = csa_inverse(&SA,i);
   }
   mygettime(&after);
   t = mylaptime(&before,&after);
   printf("inverse %f sec\n",t);
#endif

   return 0;
}
