/* compressed suffix arrays 

 */

#ifndef _COMPARRAY_H_
#define _COMPARRAY_H_

#ifdef USE_MMAP
#include "mman.h"
#endif

#define SIGMA 256

typedef struct csa {
  int n,m;
  int l,two,two2;
  int K[SIGMA+2],C[SIGMA+1],C2[SIGMA+1];
  int *SA,*ISA,*R;
  unsigned short *B; /* bit */
#ifdef USE_MMAP
  MMAP *mapp,*mapi;
#endif
} CSA;

int csa_psi(CSA *SA,int i);
int csa_T(CSA *SA,int i);
int csa_inverse(CSA *SA, int suf);
void csa_decode(unsigned char *p,CSA *SA,int suf,int len);
void csa_decode2(unsigned char *p,CSA *SA,int pos,int len);
int csa_write(CSA *SA,char *fname1,char *fname2);
void csa_new(int n, int *p, unsigned char *s, char *fname1, char *fname2);
int csa_read(CSA *SA,char *fname1,char *fname2);
int initranktables(void);
void mkdecodetable(void);
int csa_lookup(CSA *SA, int i);
int *csa_batchlookup(CSA *SA,int l, int r);
int *csa_batchlookup2(CSA *SA,int l, int r);
int csa_bsearch(unsigned char *key,int keylen,CSA *SA,int *li,int *ri);
void csa_decode1line(unsigned char *p,CSA *SA,int suf,int maxlen);
void csa_decodeall(unsigned char *p,CSA *SA);


#endif
