
#ifdef QUERYREPORT
extern int CALLS, JUMPS, QUERIES, FFILL, BCALLS, DEPTH, BCELLS, OCC1, OCC2, OCC3, WORK2, EXTEND3, CHECK3, RJUMPS, DEPTH1;
#endif

#ifdef QUERYTIME
double fwdtime = 0;
double bwdtime = 0;
double type1time = 0;
double type2time = 0;
double type3time = 0;
double ticks; 
#endif


#include "search.h"
#include "persist.h"

main (int argc, char **argv)

   { byte patt[1024];
     lzindex I;
     uint i,level;

     if (argc != 2)
        { fprintf (stderr,"Usage: %s <file> searches index <file>.*\n",
                          argv[0]);
          exit (1);
        }

	// load text
     printf ("Loading index %s...\n",argv[1]);
     I = loadLZIndex (argv[1]);

	// answer queries
     printf ("Ready to answer queries\n");
#ifdef QUERYTIME
     ticks= (double)sysconf(_SC_CLK_TCK);
#endif
     while (true)
	{ printf ("pattern = ");
	  for (i=0;(patt[i]=getchar())!='\n';i++);
	  patt[i] = 0;
          if (!strcmp(patt,"END")) break;
          level = 2;
          if ((patt[0]=='c') && (patt[1]==':'))
             { level = 0; strcpy(patt,patt+2); }
          else if ((patt[0]=='p') && (patt[1]==':'))
             { level = 1; strcpy(patt,patt+2); }
          else if ((patt[0]=='s') && (patt[1]==':'))
             { level = 2; strcpy(patt,patt+2); }
          printf ("%s: %i occurrences\n",patt,search (I,patt,level));
        }
#ifdef QUERYTIME
     fprintf (stderr,"Forward time: %f secs\n",fwdtime);
     fprintf (stderr,"Backward time: %f secs\n",bwdtime);
     fprintf (stderr,"Report type1 time: %f secs\n",type1time);
     fprintf (stderr,"Report type2 time: %f secs\n",type2time);
     fprintf (stderr,"Report type3 time: %f secs\n",type3time);
     fprintf (stderr,"Overall time: %f secs\n",
			(fwdtime+bwdtime+type1time+type2time+type3time));
#endif
#ifdef QUERYREPORT
     fprintf (stderr,"avg children traversed in childLZTrie= %f\n",JUMPS/(float)CALLS);
     fprintf (stderr,"avg fwd cells filled = %f\n",CALLS/(float)QUERIES);
     fprintf (stderr,"avg bwd cells filled using fwd = %f\n",FFILL/(float)QUERIES);
     fprintf (stderr,"avg bwd cells filled using childRevTrie = %f\n",BCALLS/(float)QUERIES);
     fprintf (stderr,"avg depth work per childRevTrie call = %f\n",DEPTH/(float)BCALLS);
     fprintf (stderr,"avg depth per childRevTrie call = %f\n",DEPTH1/(float)BCALLS);
     fprintf (stderr,"avg arity work per childRevTrie call = %f\n",RJUMPS/(float)BCALLS);
     fprintf (stderr,"avg bwd cells filled = %f\n",BCELLS/(float)QUERIES);
     fprintf (stderr,"avg occs type 1 = %f, type 2 = %f, type 3 = %f, total = %f\n",
			OCC1/(float)QUERIES,OCC2/(float)QUERIES,OCC3/(float)QUERIES,
			(OCC1+OCC2+OCC3)/(float)QUERIES);
     fprintf (stderr,"avg nodes checked at step 2 = %f\n",WORK2/(float)QUERIES);
     fprintf (stderr,"avg work to extend cells at step 3 = %f\n",EXTEND3/(float)QUERIES);
     fprintf (stderr,"avg work to check cells at step 3 = %f\n",CHECK3/(float)QUERIES);
#endif

	// free structures
     printf ("Freeing index\n");
     destroyLZIndex (I);

     exit(0);
   }
