
// Implements the persistence of the LZIndex

#include "persist.h"

        // writes index to filename fname.*

void saveLZIndex (lzindex I, char *fname)

   { char fnamext[1024];
     FILE *f;
	// save lztrie
     sprintf (fnamext,"%s.lzt",fname);
     f = fopen (fnamext,"w");
     if (f == NULL)
	{ fprintf (stderr,"Error: cannot create file %s\n",fnamext);
	  exit(1);
  	}
     saveLZTrie (I.fwdtrie,f);
     if (fclose(f) != 0)
	{ fprintf (stderr,"Error: cannot write file %s\n",fnamext);
	  exit(1);
  	}
	// save revtrie and rev
     sprintf (fnamext,"%s.rvt",fname);
     f = fopen (fnamext,"w");
     if (f == NULL)
	{ fprintf (stderr,"Error: cannot create file %s\n",fnamext);
	  exit(1);
  	}
     saveRevTrie (I.bwdtrie,f);
     saveNodemap (I.rev,f);
     if (fclose(f) != 0)
	{ fprintf (stderr,"Error: cannot write file %s\n",fnamext);
	  exit(1);
  	}
   }

        //loads index from filename fname.*

lzindex loadLZIndex (char *fname)

   { lzindex I;
     char fnamext[1024];
     FILE *f;
     uint depth,*rmap,i,j,n,rn;
	// load lztrie
     sprintf (fnamext,"%s.lzt",fname);
     f = fopen (fnamext,"r");
     if (f == NULL)
	{ fprintf (stderr,"Error: cannot open file %s\n",fnamext);
	  exit(1);
  	}
     I.fwdtrie = loadLZTrie (f);
     fclose (f);
	// load revtrie and rev
     sprintf (fnamext,"%s.rvt",fname);
     f = fopen (fnamext,"r");
     if (f == NULL)
	{ fprintf (stderr,"Error: cannot open file %s\n",fnamext);
	  exit(1);
  	}
     I.bwdtrie = loadRevTrie (f,I.fwdtrie);
     I.rev = loadNodemap (f);
     setRevTrieMap (I.bwdtrie,I.rev);
     fclose (f);
	// produce rmap
     n = I.fwdtrie->n;
     rn = I.bwdtrie->n;
     rmap = malloc (n*sizeof(uint));
     rmap[0] = ROOT;
     i = ROOT;
     for (j=1;j<rn;j++)
        { i = nextRevTrie (I.bwdtrie,i);
          rmap[rthRevTrie(I.bwdtrie,j)] = i; 
				// when equality, the innermost gets the mapping
        }
     I.rmap = createNodemap (rmap,n,rn);
     free (rmap);
	// return index
     return I;
   }

