
#include "index.h"
#include "persist.h"

static void txtload (char *fname, byte **text, uint *n)
 
   { int f;
     struct stat sdata;
 
        /* read the file into memory */
     if (stat(fname,&sdata) != 0)
        { fprintf (stderr,"Cannot stat file %s\n",fname);
          exit(1);
        }
 
     *n = sdata.st_size;
     *text = malloc(*n+1);
 
     f = open (fname,O_RDONLY);
     if (f == -1)
        { fprintf (stderr,"Cannot open file %s\n",fname);
          exit(1);
        }
 
     if (read(f,*text,*n) != *n)
        { fprintf (stderr,"Cannot read file %s\n",fname);
          exit(1);                                                              
        }
 
        /* terminator */
     (*text)[*n] = 0;
 
     close (f);
   }                                                                            

main (int argc, char **argv)

   { byte *text;
     lzindex I;
     uint i,n,level;

     if (argc != 2)
	{ fprintf (stderr,"Usage: %s <file> indexes <file> and produces files "
		  "<file>.*,\n       you can then delete <file>\n",argv[0]);
	  exit (1);
	}
	// load text
     printf ("Loading %s...\n",argv[1]);
     txtload (argv[1],&text,&n);

	// build index
     printf ("Building index...\n");
     I = buildLZIndex (text);

	// save index
     printf ("Saving index...\n");
     saveLZIndex (I,argv[1]);

	// free structures
     printf ("Freeing index\n");
     destroyLZIndex (I);

     exit(0);
   }
