
 // Indexing module

#include "index.h"
#include "trie.h"

	// creates lztrie over a null-terminated text
	// it also creates *ids and *maxdepth

#ifdef INDEXREPORT
struct tms time;
clock_t t1,t2;
uint ticks;
#endif

lztrie buildLZTrie (byte *text, uint *maxdepth)

   { trie T;
     uint n;
     uint *parent;
     byte *letters;
     uint *ids;
     lztrie LZT;
	// first creates a full trie T
#ifdef INDEXREPORT
     ticks= sysconf(_SC_CLK_TCK);
     times(&time); t1 = time.tms_utime;
     printf ("  Building LZTrie...\n"); fflush(stdout);
     printf ("    Building normal trie...\n"); fflush(stdout);
#endif
     T = createTrie();
     do text = insertTrie (T,text);
     while (text[-1]);
	// now compresses it
#ifdef INDEXREPORT
     times(&time); t2 = time.tms_utime;
     printf ("    User time: %f secs\n",(t2-t1)/(float)ticks); fflush(stdout);
     t1 = t2;
     printf ("    Representing with parentheses, letters and ids...\n"); fflush(stdout);
#endif
     n = T->nid;
     parent = malloc (((2*n+W-1)/W)*sizeof(uint));
     letters = malloc (n*sizeof(byte));
     ids = malloc (n*sizeof(uint));
     *maxdepth = representTrie (T,parent,letters,ids);
#ifdef INDEXREPORT
     times(&time); t2 = time.tms_utime;
     printf ("    User time: %f secs\n",(t2-t1)/(float)ticks); fflush(stdout);
     t1 = t2;
     printf ("    Freing trie...\n"); fflush(stdout);
#endif
     destroyTrie(T);
#ifdef INDEXREPORT
     times(&time); t2 = time.tms_utime;
     printf ("    User time: %f secs\n",(t2-t1)/(float)ticks); fflush(stdout);
     t1 = t2;
     printf ("    Creating compressed trie...\n"); fflush(stdout);
#endif
     LZT = createLZTrie (parent,letters,ids,n);
     free (ids);
#ifdef INDEXREPORT
     times(&time); t2 = time.tms_utime;
     printf ("    User time: %f secs\n",(t2-t1)/(float)ticks); fflush(stdout);
     t1 = t2;
     printf ("  End of LZTrie\n"); fflush(stdout);
#endif
     return LZT;
   }

	// builds reverse trie from LZTrie and maximum LZTrie depth
	// returns reverse ids

revtrie buildRevTrie (lztrie T, uint maxdepth, uint **rids)

   { byte *str;
     uint n,depth,j;
     trieNode i;
     trie RT;
     uint *parent;
     revtrie CRT;
	// first create a full trie RT
#ifdef INDEXREPORT
     times(&time); t1 = time.tms_utime;
     printf ("  Building RevTrie...\n"); fflush(stdout);
     printf ("    Creating full trie...\n"); fflush(stdout);
#endif
     str = malloc (maxdepth*sizeof(byte));
     RT = createTrie(); 
     i = ROOT; depth = 0;
     for (j=1;j<T->n;j++)
	{ i = nextLZTrie (T,i,&depth);
	  str[maxdepth-depth] = letterLZTrie (T,i);
          insertstringTrie (RT,str+maxdepth-depth,depth,idLZTrie(T,i));
	}
     free (str);
        // now compresses it
#ifdef INDEXREPORT
     times(&time); t2 = time.tms_utime;
     printf ("    User time: %f secs\n",(t2-t1)/(float)ticks); fflush(stdout);
     t1 = t2;
     printf ("    Representing with parentheses and ids...\n"); fflush(stdout);
#endif
     n = RT->nid; // # of non-mute nodes
     parent = malloc (((2*n+W-1)/W)*sizeof(uint));
     *rids = malloc (n*sizeof(uint));
     representTrie (RT,parent,NULL,*rids);
#ifdef INDEXREPORT
     times(&time); t2 = time.tms_utime;
     printf ("    User time: %f secs\n",(t2-t1)/(float)ticks); fflush(stdout);
     t1 = t2;
     printf ("    Freeing trie...\n"); fflush(stdout);
#endif
     destroyTrie(RT);
#ifdef INDEXREPORT
     times(&time); t2 = time.tms_utime;
     printf ("    User time: %f secs\n",(t2-t1)/(float)ticks); fflush(stdout);
     t1 = t2;
     printf ("    Creating compressed trie...\n"); fflush(stdout);
#endif
     CRT = createRevTrie (parent,T,n);
#ifdef INDEXREPORT
     times(&time); t2 = time.tms_utime;
     printf ("    User time: %f secs\n",(t2-t1)/(float)ticks); fflush(stdout);
     t1 = t2;
     printf ("  End of RevTrie...\n"); fflush(stdout);
#endif
     return CRT;
   }

	// builds Map from LZTrie, for temporary use

uint *buildMap (lztrie T)

   { uint *map;
     trieNode i;
     uint n,j,depth;
#ifdef INDEXREPORT
     times(&time); t1 = time.tms_utime;
     printf ("  Building Map...\n"); fflush(stdout);
     printf ("    Computing indexes...\n"); fflush(stdout);
#endif
     n = T->n;
     map = malloc (n*sizeof(uint));
     map[0] = ROOT; depth = 0;
     i = ROOT;
     for (j=1;j<n;j++)
	{ i = nextLZTrie (T,i,&depth);
	  map[rthLZTrie(T,j)] = i;
	}
#ifdef INDEXREPORT
     times(&time); t2 = time.tms_utime;
     printf ("    User time: %f secs\n",(t2-t1)/(float)ticks); fflush(stdout);
     t1 = t2;
     printf ("  End of BuildMap...\n"); fflush(stdout);
#endif
     return map;
   }

	// builds Map and Rev from RevTrie, ids and rids, which get freed

void buildMaps (lztrie T, revtrie RT, uint *rids, nodemap *RMap, nodemap *Rev)

   { uint *rmap,*rev,*map;
     trieNode i;
     uint n,rn,j;
#ifdef INDEXREPORT
     times(&time); t1 = time.tms_utime;
     printf ("  Building RMap and Rev...\n"); fflush(stdout);
     printf ("    Computing indexes...\n"); fflush(stdout);
#endif
     map = buildMap (T);
     n = T->n; rn = RT->n;
     rmap = malloc (n*sizeof(uint));
     rev = malloc (rn*sizeof(uint));
     rmap[0] = ROOT; rev[0] = ROOT;
     i = ROOT;
     for (j=1;j<rn;j++)
	{ i = nextRevTrie (RT,i);
	  rmap[rids[j]] = i; // when equality, the innermost gets the mapping
	  rev[j] = map[rids[j]];
	}
     free (rids);
     free (map);
#ifdef INDEXREPORT
     times(&time); t2 = time.tms_utime;
     printf ("    User time: %f secs\n",(t2-t1)/(float)ticks); fflush(stdout);
     t1 = t2;
     printf ("    Creating nodemap...\n"); fflush(stdout);
#endif
     *RMap = createNodemap (rmap,n,rn);
     free (rmap);
     *Rev = createNodemap (rev,rn,n);
     free (rev);
#ifdef INDEXREPORT
     times(&time); t2 = time.tms_utime;
     printf ("    User time: %f secs\n",(t2-t1)/(float)ticks); fflush(stdout);
     t1 = t2;
     printf ("  End of RMap\n"); fflush(stdout);
#endif
   }

        // creates lzindex over a null-terminated text
	// frees text
lzindex buildLZIndex (byte *text)

   { lzindex I;
     uint *rids,maxdepth;

	// build index
     I.fwdtrie = buildLZTrie (text,&maxdepth);
     free (text);
     I.bwdtrie = buildRevTrie (I.fwdtrie,maxdepth,&rids);
     buildMaps (I.fwdtrie,I.bwdtrie,rids,&I.rmap,&I.rev);
     setRevTrieMap (I.bwdtrie,I.rev);
     return I;
   }

