

// Implements operations over a bitmap

#ifndef BITMAPINCLUDED
#define BITMAPINCLUDED

#include "basics.h"

typedef struct sbitmap
   { uint *data;
     uint n;        // # of bits
     uint nbits;    // # of bits of superblock cell
     uint sbits;    // # of bits of block cell
     uint *sdata;   // superblock counters
     uint *bdata;   // block counters
   } *bitmap;

	// creates a bitmap structure from a bitstring, which gets owned
bitmap createBitmap (uint *string, uint n);
	// rank(i): how many 1's are there before position i, not included
uint rank (bitmap B, uint i);
	// destroys the bitmap, freeing the original bitstream
void destroyBitmap (bitmap B);
	// popcounts 1's in x
uint popcount (register int x);


#endif

