
/* This code is from Gonzalo Navarro and Mathieu Raffinot, 1998.
   It can be freely used for academic teaching/learning and research
   purposes. Usage for direct or indirect commercial advantage is not
   allowed without written permission from the authors.
*/

#include <stdio.h>
#include "lzgrep.h"
#include "util.h"
#include "blocks.h"
#include "search.h"
#include "search_kmp_onthefly.h"

typedef unsigned char uchar;


int next[1024];

void preproc_kmp_onthefly ()
        {
            int i, j;
	    int m = PatternList.lmin;
	    char *patt = PatternList.next_pattern->pattern;
	    static int preproc = 0;
	    if (!preproc) preproc = 1;
	    else return;

            if (m >= 1024)
             { fprintf (stderr,"Error: pattern length must be < 1024\n");
               exit(1);
             }

          i = 0;
          j = next[0] = -1;
          do { if( j==(-1) || patt[i]==patt[j] ) {
                    i++;
                    j++;
                    next[i] = (patt[j]==patt[i]) ? next[j] : j;
               }
               else j = next[j]; 
	  }while( patt[i] != 0 );
        }


int search_kmp_onthefly() {

	int rbytes,delta;
	register int j;
        int m = PatternList.lmin;
	char *patt = PatternList.next_pattern->pattern;
	OTF_SearchState OTF_State;
	

	OTF_cleanState(&OTF_State);

	while ((rbytes=OTF_readUncompressed(&OTF_State))>0) {

		j = 0;

		while(OTF_State.rpos-OTF_State.tpos >= m) {
 		     if ( ( j==-1 ) || ( patt[j] == OTF_charAt(OTF_State.tpos)) )
			 {  
			     OTF_State.tpos++;
			     j++; 
			     if( patt[j] == 0 ) {
				   if (OTF_reportMatch(&OTF_State))
				      return(OTF_State.count);
				    j = next[j];
	                     }
	                 }
	                 else j = next[j];
		}
	      OTF_State.tpos=OTF_State.rpos;
	} 

      return(OTF_State.count);
}
