#include "search_bmsimple_multi.h"
#include "lzgrep.h"
#include "format.h"
#include "blocks.h" 

static int *B[256];
static unsigned char *mask;
static int bytes_mask;
static int ibytes_mask;
#define reset_mask { ibytes_mask=bytes_mask;while(ibytes_mask--) mask[ibytes_mask] = 0xFF; }
#define set_empty_flag(flag) {flag=0;ibytes_mask=bytes_mask;while(ibytes_mask--) flag |= mask[ibytes_mask];}
#define and_mask(c,i) {ibytes_mask=bytes_mask;while(ibytes_mask--) mask[ibytes_mask] &=M[c][i][ibytes_mask];}
static unsigned char **M[256];

void preproc_bmsimple_multi_4()
  int c, i, j, m, k;
  char *pt;
  int *BB;
  void *MM;
  void *MMM;
  TypePatternNode *next = PatternList.next_pattern;
  static int preproc = 0;

  if (!preproc) preproc = 1;
  else return;

  m = PatternList.lmin;
  k = PatternList.count;

  BB = (void *) malloc (256 * m * sizeof (int));
 
  for (c = 0; c < 256; c++) {
    B[c] = BB + c * m;
    
  }

  for (i = 0; i<m; i++) {
      for (c = 0; c < 256; c++) {
	  B[c][i] = i + 1;
      }
  }
  k = 0;
  while(next != NULL) {
    pt=next->pattern+strlen(next->pattern)-PatternList.lmin;
    

    for (i = 0; i<m; i++) {
      for (j = i; pt[j]; j++) {
	if (!k || B[pt[i]][j] > (j - i)) {
		if (optIgnoreCase) {
	  		B[tolower(pt[i])][j] = j - i;
	  		B[toupper(pt[i])][j] = j - i;
		} else {
	  		B[pt[i]][j] = j - i;
	  	}
	}
      }
    }
    k++;
    next = next->next_pattern;
  }				

}

int search_bmsimple_multi_4() {
  register int m = PatternList.lmin;
  register long i, k, j, length, oldj;
  register long from;
  register int offset, shift;
  int flag;
  TypeBlock *pblock_i, *pblock, *pblock_j;
  BLK_SearchState BLK_State;
  int brk;


  BLK_CleanState(&BLK_State);

  for (j=-1; j <  FirstFree; j++) {
        pblock=get_block(j);
        pblock->length=0;
        pblock->ref = 0;
        pblock->nlcount=0;
        pblock->c=j+1;
  }

  i = free_ent = FirstFree;

  pblock = get_block(i-1);
  pblock->c = oldj = getcode ();
  BLK_State.rpos++;
  if (oldj == -1)
    return (BLK_State.count); 
  

  while (1)
   {
     readBlocks:
      while (BLK_State.rpos - BLK_State.tpos <= m) {
	if ((j = getcode ()) == -1) goto endText;
	if (j == Clear) {
	    process_block_clear(i,&BLK_State);
	    free_ent = i = FirstFree - 1;
	    if ((j = getcode ()) == -1) goto endText;
	    pblock = get_block(i-1);
	    pblock->c = j;
	}
	if (free_ent < maxmaxcode)
	  i = free_ent++;
	else
	  i++;
	pblock_j=get_block(oldj);
	pblock=get_block(j-1);
	pblock_i=get_block(i);
	pblock_i->ref = oldj;
	pblock_i->c = pblock->c;
	pblock_i->length=pblock_j->length+1;
	oldj = j;
	BLK_State.rpos += pblock_i->length;
	 if (indPrintMatches) {
               pblock_i->nlcount = pblock_j->nlcount;
              if (pblock_i->c==NEWLINE)
                       pblock_i->nlcount++;
              BLK_State.nlrpos += pblock_i->nlcount;
         } else {
              if (pblock_j->nlcount)
                  pblock_i->nlcount = pblock_j->nlcount;
              else if (pblock_i->c==NEWLINE)
                  pblock_i->nlcount = pblock_i->length;
              else  pblock_i->nlcount = 0;
         }
	 /* If is a matched line */
	 if (BLK_State.nlaft)  {
	      brk=process_block_after_match(i,&BLK_State);
	      if (brk) goto endText;
	 }
      }

    /* now I've read one extra block. try to shift */
    j = i;
    from = BLK_State.rpos;
    pblock = pblock_i;
    while (1)
     {
      from -= pblock->length;
      pblock = get_block(j-1);
      offset = from - 1 - BLK_State.tpos;
      if (offset < BLK_State.unchk) break;
      shift = B[pblock->c][offset];
      if (shift > 0) {
	      if (BLK_State.unchk) {
		      if (BLK_State.unchk > shift)
			      BLK_State.unchk-=shift;
		      else
			      BLK_State.unchk=0;
	       }
		BLK_State.tpos += shift;
		
		goto readBlocks;
      } 
      j--;
    }

    /* unable to shift by explicit characters.
       try implicit characters */
    j = i - 1;
    from = BLK_State.rpos -pblock_i->length;
    while (1)
     {
      pblock = get_block(j);
      from -= pblock->length;
      length = pblock->length - 2;
      k = j;
      offset = from - BLK_State.tpos;
      if (offset + length < BLK_State.unchk) goto expandLast;
      while (length >= 0)
       {
	k = pblock->ref;
	pblock=get_block(k);
	shift = B[pblock->c][offset + length];
	if (shift > 0) {
	  if (BLK_State.unchk) {
	       if (BLK_State.unchk > shift)
		       BLK_State.unchk -= shift;
	       else BLK_State.unchk = 0;
	  }
	  BLK_State.tpos += shift;
	  
	  goto readBlocks;
	} 

	length--;
	if (offset + length < BLK_State.unchk)
	  goto expandLast;
      }
      j--;
    }

    /* only the last (i-th) block rests to be tested */
  expandLast:
    length = pblock_i->length - 2;
    j = i;
    from = BLK_State.rpos - pblock_i->length;
    offset = from - BLK_State.tpos;
    pblock=pblock_i;
    while (offset + length >= m)
     {
      j = pblock->ref;
      pblock=get_block(j);
      length--;
    }
    pblock_j=pblock;
    while ((length >= 0) && (offset + length >= BLK_State.unchk))
     {
      k = pblock->ref;
      pblock=get_block(k);
      shift = B[pblock->c][offset + length];
      if (shift > 0) {
	if (BLK_State.unchk) {
		if (BLK_State.unchk > shift)
			BLK_State.unchk-=shift;
		else
			BLK_State.unchk=0;
	}
	BLK_State.tpos += shift;
	
	goto readBlocks;
      } 

      length--;
    }

    
    
    
    /* Check uncheked text */
    if (BLK_State.unchk) {
         if (!check_oldbuf(&BLK_State)) {
               BLK_State.tpos++;
               BLK_State.unchk--;
               goto readBlocks;
	 }
     }

     /* Check patterns longer than lmin */
    if (!check_residual_patterns(i,&BLK_State)) {
	    BLK_State.tpos++;
	    if (BLK_State.unchk) BLK_State.unchk--;
	    goto readBlocks;
    }

    /* it passed all the tests, report the match */
    process_block_match(i,&BLK_State);
  }
endText:return (BLK_State.count);
}
