#include "search_bmsimple.h"
#include "lzgrep.h"
#include "format.h"
#include "blocks.h"
#include "util.h"

static int *B[256];

void preproc_bmsimple() {
     int i,j;
     int c;
     int *BB;
     int m = PatternList.lmin;
     char *patt = PatternList.next_pattern->pattern;
     static int preproc = 0;

     if (!preproc) preproc = 1;
     else return;

     BB = (int *) malloc (256 * m * sizeof (int));
     for (c = 0; c < 256; c++) 
         B[c] = BB + c * m;
     for (i = 0; patt[i]; i++)
         for (c = 0; c < 256; c++)
                   B[c][i] = i + 1;
     for (i = 0; patt[i]; i++)
         for (j = i; patt[j]; j++) {
              if (optIgnoreCase) {
	         B[tolower(patt[i])][j] = j - i;
	         B[toupper(patt[i])][j] = j - i;
              } else {
	         B[patt[i]][j] = j - i;
              }
         }
}

int search_bmsimple(int opt);
int search_bmsimple_1() {  /* BM-simple */
	return(search_bmsimple(1));
}
int search_bmsimple_2() {  /* BM-simple-opt */
	return(search_bmsimple(2));
}
int search_bmsimple_3() {  /* BM-simple-lf */
	return(search_bmsimple(3));
}
int search_bmsimple(int opt) {
	int  i,j,k,oldj;
	int length,from,offset,shift;
	int m = PatternList.lmin;
	int brk;
	TypeBlock *pblock_i, *pblock,*pblock_j;
	BLK_SearchState BLK_State;

	BLK_CleanState(&BLK_State);
	for (j=-1; j <  FirstFree; j++) {
		pblock=get_block(j);
	        pblock->length=0;
	        pblock->ref = 0;
		pblock->nlcount=0;
		pblock->c=j+1;
	}
	i = free_ent = FirstFree;

	pblock=get_block(i-1);
	pblock->c = oldj = getcode();
	BLK_State.rpos++;
	if (oldj == -1) return(BLK_State.count);

	while(1) {
   		readBlocks:
		while (BLK_State.rpos - BLK_State.tpos <= m) {
			if ((j=getcode()) == -1) goto endText;
			if (j == Clear) {
				process_block_clear(i,&BLK_State);
				free_ent = i = FirstFree - 1;
				if ((j=getcode()) == -1) goto endText;
				pblock=get_block(i-1);
				pblock->c = j;
			}
			if (free_ent < maxmaxcode) 
				i = free_ent++;
			else 
				i++;
			pblock_j=get_block(oldj);
			pblock=get_block(j-1);
			pblock_i=get_block(i);
			pblock_i->ref = oldj;
			pblock_i->length=pblock_j->length+1;
			pblock_i->c = pblock->c;
			oldj = j;
			BLK_State.rpos += pblock_i->length;
			if (indPrintMatches) {
				pblock_i->nlcount = pblock_j->nlcount;
				if (pblock_i->c==NEWLINE)
					pblock_i->nlcount++;
				BLK_State.nlrpos += pblock_i->nlcount;
			} else {
				if (pblock_j->nlcount)
			    		pblock_i->nlcount = pblock_j->nlcount;
		        	else if (pblock_i->c==NEWLINE)
                            		pblock_i->nlcount = pblock_i->length;
				else  pblock_i->nlcount = 0;
			}
                        /* If is a matched line */
			if (BLK_State.nlaft)  {
				brk=process_block_after_match(i,&BLK_State);
			        if (brk) goto endText;
                        }
                        if ((opt>1) && (BLK_State.rpos-BLK_State.tpos <= m) && (BLK_State.rpos > BLK_State.tpos)) {
                        	shift = B[pblock_i->c][BLK_State.rpos-BLK_State.tpos-1];
                        	if (shift > 0) {
                        		if (BLK_State.unchk) {
                                		if (BLK_State.unchk > shift) 
					   		BLK_State.unchk-=shift;
                                    		else 
					   		BLK_State.unchk = 0;
                                	}
                 			BLK_State.tpos += shift;
                 		}
                 	}
                            
		}

		/* now I've read one extra block, try to shift */
		if (opt<=3) {
		   j = i;
		   from = BLK_State.rpos;
		   pblock = pblock_i;
		   while (1) {
			from -= pblock->length;
			pblock=get_block(j-1);
			offset = from -1 -BLK_State.tpos;
			if (offset < BLK_State.unchk) break;
			shift = B[pblock->c][offset];
			if (shift > 0) {
                                if (BLK_State.unchk) {
                                    if (BLK_State.unchk > shift) 
					   BLK_State.unchk-=shift;
                                    else 
					   BLK_State.unchk = 0;
                                } 
				BLK_State.tpos += shift;
				goto readBlocks;
			}
			j--;
		   }
		}

		/* Unable to shift explicit characters,
		 * try implicit characters */
		if (opt==3) goto expandLast;
		expandInternal:
		from = BLK_State.rpos - pblock_i->length;
		j = i-1;
		while (1) {
			pblock=get_block(j);
			from -= pblock->length;
			length = pblock->length-2;
			k=j;
			offset = from - BLK_State.tpos;
			if (offset+length < BLK_State.unchk) {
				break;
			}
			while (length >= 0) {
				k = pblock->ref;
			        pblock=get_block(k);
				shift = B[pblock->c][offset+length];
				if (shift > 0) {
                                        if (BLK_State.unchk) {
                                            if (BLK_State.unchk > shift) 
						    BLK_State.unchk-=shift;
                                            else BLK_State.unchk = 0;
                                        } 
					BLK_State.tpos += shift;
					goto readBlocks;
				}
				length--;
				if (offset+length < BLK_State.unchk) {
					if (opt==3) goto checkMatch;
					else goto expandLast;
				}
		
			}
			j--;
		}
		if (opt==3) goto checkMatch;

		/* only the last (i-th) block rests to be tested */
		expandLast:
			length = pblock_i->length -2;
			j=i;
		        from = BLK_State.rpos - pblock_i->length;
			offset = from - BLK_State.tpos;
			pblock=pblock_i;
			while (offset+length >= m) {
				j = pblock->ref;
				pblock=get_block(j);
				length--;
			}
			pblock_j=pblock;
			while ((length >= 0) && (offset+length >= BLK_State.unchk)) {
				k = pblock->ref;
				pblock=get_block(k);
				shift = B[pblock->c][offset+length];
				if (shift > 0) {
                                        if (BLK_State.unchk) {
                                            if (BLK_State.unchk > shift) 
						    BLK_State.unchk-=shift;
                                            else 
						    BLK_State.unchk = 0;
                                        } 
					BLK_State.tpos += shift;
					goto readBlocks;
				}
				length--;
			}
			if (opt==3) goto expandInternal;
		
		checkMatch:
                /* Check uncheked text */
                if (BLK_State.unchk) {
                    if (!check_oldbuf(&BLK_State)) {
                           BLK_State.tpos++;
                           BLK_State.unchk--; 
			   goto readBlocks;
                    }
                }
		/* It passed all the tests, report the match */
		brk=process_block_match(i,&BLK_State);
		if (brk) goto endText;
	}
	endText:
		return(BLK_State.count);
}
