#include "search_bmblocks_multi.h"
#include "lzgrep.h"
#include "format.h"
#include "blocks.h"

#define MAX_NODE_BLOCKS 500

#define trie(n)  tree[n>>16][n&0xFFFF]
#define MAXPAT  256
#define MAXPATFILE 260000
#define BLOCKSIZE  8192
#define max_num    30000  

typedef struct _node_pos {
  int pos;
  struct _node_pos *next;
} POSITION;
#define MIN_SIZE_HASH 4

typedef struct {
   char c;
   int next;
} NEXT_NODE;
#define NHASH ((unsigned int)4294967279)
     
#define NEXT_N(n,c) (trie(n).size_hash>MIN_SIZE_HASH ?\
                         NEXT_HASH(n,c) :\
                         NEXT_SECUENCIAL(n,c) \
                     ) 
        
typedef struct
{
  POSITION * comp_pos;		/* Complete positions */
  POSITION * suf_pos;		/* Suffix positions */
  NEXT_NODE *next;
  short nhijos;
  short size_hash;
  int suffix_link;
  short es_prefijo;
  short path_len;
} NODE;
NODE * tree[MAX_NODE_BLOCKS];

int NEXT_SECUENCIAL(int n, char c)  {
                                int i,nx;
                                nx=-1;
                                for(i=0;i<trie(n).nhijos;i++){
                                 if (trie(n).next[i].c==c)
                                   { nx=i; break; }
				}
                                if (nx==-1) nx=0;
                                else nx=trie(n).next[nx].next;
                                return(nx);
                              };
int NEXT_HASH(int n, char c) {
                        int i,nx;
                        nx=i=(c*NHASH)%(trie(n).size_hash);
                        if (trie(n).next[i].c==0)  
                           nx=0;
                        else if (trie(n).next[i].c==c)
                           nx = trie(n).next[i].next;
                        else {
                          i++;
                          if (i>=trie(n).size_hash) i=0;
                          while(i!=nx) {
                            if (trie(n).next[i].c==c) break;
                            if (trie(n).next[i].c==0) break;
                            i++;
                          if (i>=trie(n).size_hash) i=0;
                          }
                          if (trie(n).next[i].c==c)
                            nx=trie(n).next[i].next;
                          else nx=0;
                        }
                       return(nx);
                    }
                         

set_next(int n, int c, int next) {
  int i,j,sz,cc;
  NEXT_NODE *nn;
        if (trie(n).nhijos < MIN_SIZE_HASH) {
          if (trie(n).nhijos==0)  {
           trie(n).next = (NEXT_NODE *)malloc(MIN_SIZE_HASH*sizeof(NEXT_NODE));
           memset(trie(n).next,0,MIN_SIZE_HASH*sizeof(NEXT_NODE));
           trie(n).size_hash = MIN_SIZE_HASH;
          } 
        i = trie(n).nhijos++;
        trie(n).next[i].c = c;
        trie(n).next[i].next = next;
        } else {
           if (2*trie(n).nhijos >= trie(n).size_hash) {
              sz = 2*trie(n).size_hash;
              nn = (NEXT_NODE *) malloc(sz*sizeof(NEXT_NODE));
              if (nn==NULL) {
                fprintf(stderr,"Not enough memory\n");
                exit(2);
              }
              memset(nn,0,sz*sizeof(NEXT_NODE));
              for (i=0;i<trie(n).size_hash;i++) {
                cc=trie(n).next[i].c;
                if (cc) {
                  j=(cc*NHASH)%sz;
                  while(nn[j].c) {
                    j++;
                   if (j>=sz) j=0;
                  }
                  nn[j].c = cc;
                  nn[j].next =trie(n).next[i].next;
                }
              }
              //free(trie(n).next);
              trie(n).next = nn;
              trie(n).size_hash = sz;
           }
           j=(c*NHASH)%trie(n).size_hash;
           while(1) {
             if(trie(n).next[j].c==0) {
                trie(n).next[j].c=c;
                trie(n).next[j].next=next;
		trie(n).nhijos++;
                break;
              } 
             j++; if (j>=trie(n).size_hash) j=0;
          }
     }
}

void preproc_bmblocks_multi () {
  int i, j, k, l, n, nc, oldn;
  int len, pos;
  int nblocks;
  int max_node;
  int pnode;
  char c;
  int mem;
  POSITION * p, *nextp,*aux;
  POSITION cab;
  TypePatternNode *next;
  int m = PatternList.lmin;
  char *patt;
  struct node_list
  {
    int node;
     int pnode;
     char c;
     struct node_list *next;
  } *list, *l1, *l2, *l3;

  tree[0] = (NODE *) malloc ((1<<16)*sizeof(NODE));
  if (tree[0] == NULL)
    {
      fprintf (stderr,"Not enough memory.\n");
      exit (2);
    }
  memset(tree[0],0,(1<<16)*sizeof(NODE));
  nblocks = 1;
  max_node = (1<<16)*nblocks-1;

  /* Llena trie con patrones y sus sufijos */ 
  nc = 0;
  next = PatternList.next_pattern;
  while (next != NULL) {
      patt = next->pattern;
      len = strlen (patt);
      for (j =len-m; j < len; j++)
	{
	  n = 0;
	  for (k = j; k < len; k++)
	    {
	      oldn = n;
	      c = patt[k];
	      if (!NEXT_N(oldn,c))
		{
		  /* Se crea nodo hijo por caracter c */ 
		  n = ++nc;
		  if (n > max_node) {
		       if (nblocks >= (MAX_NODE_BLOCKS-1)) {
                          fprintf(stderr,"Max blocks reached at node %d\n",n); 
			  exit(2);
		       }
                       tree[nblocks] = (NODE *) malloc ((1<<16)*sizeof(NODE));
                       if (tree[nblocks] == NULL) {
                          fprintf (stderr,"Not enough memory.\n");
                          exit (1);
                       }
                       memset(tree[nblocks],0,(1<<16)*sizeof(NODE));
                       nblocks++;
                       max_node = (1<<16)*nblocks-1;
		  }
		  trie(n).comp_pos = NULL;
		  trie(n).suf_pos = NULL;
                  set_next(oldn,c,n);
		  trie(n).es_prefijo = 0;
		  trie(n).path_len = trie(oldn).path_len + 1;
		}
	      else
		{
		  n = NEXT_N(oldn,c);
		}
	      
           	/* Inserta en lista posiciones
                de aparicion en orden decreciente */ 
		cab.next = trie(n).comp_pos;
	        p = &cab;
	        nextp = p->next;
	        while (nextp != NULL && nextp->pos > k)
		{
		  p = nextp;
		  nextp = p->next;
		}
	      if (nextp == NULL || nextp->pos < k)
		{
		  aux= (POSITION *) malloc (sizeof (POSITION));
                  p->next = aux;
                  if (p->next == NULL) {
                      fprintf(stderr,"Not enough memory\n");
                      exit(2);
                  }
		  p = p->next;
		  p->pos = k;
		  p->next = nextp;
		}
	      trie(n).comp_pos = cab.next;
	      if (k == (trie(n).path_len - 1))
		trie(n).es_prefijo = 1;
	    }
	}
        next = next->next_pattern;
    }
  
  /* Recorre en orden de nivel */ 
  list = (struct node_list *) malloc (sizeof (struct node_list));
  list->node = 0;
  list->pnode = 0;
  list->next = NULL;
  while (list != NULL)
    {
      l1 = list;
      list = NULL;
      while (l1 != NULL)
	{
	  
	    /* Visito nodo */ 
	    /* Suffix link */ 
	    if (l1->pnode == 0)
	    trie(l1->node).suffix_link = 0;
	  
	  else
	    trie(l1->node).suffix_link =
              NEXT_N(trie(l1->pnode).suffix_link,l1->c);
	  
	    /* posiciones sufijo */ 
	    if (l1->pnode == 0)
	    {
	      trie(l1->node).suf_pos = NULL;
	    }
	  else
	    {
	      if (trie(trie(l1->node).suffix_link).es_prefijo)
		{
		  trie(l1->node).suf_pos =
		    (POSITION *) malloc (sizeof (POSITION));
		  trie(l1->node).suf_pos->pos =
		    trie(trie(l1->node).suffix_link).path_len - 1;
		  trie(l1->node).suf_pos->next =
		    trie(trie(l1->node).suffix_link).suf_pos;
		}
	      else
		{
		  trie(l1->node).suf_pos =
		    trie(trie(l1->node).suffix_link).suf_pos;
		}
	    }
	  for (i = 0; i < 256; i++)
	    {
	      if (NEXT_N(l1->node,i) > 0)
		{
		  if (list == NULL)
		    {
		      list =
			(struct node_list *)
			malloc (sizeof (struct node_list));
		      list->node = NEXT_N(l1->node,i);
		      list->pnode = l1->node;
		      list->c = i;
		      list->next = NULL;
		      l3 = list;
		    }
		  else
		    {
		      l3->next =
			(struct node_list *)
			malloc (sizeof (struct node_list));
		      l3 = l3->next;
		      l3->node = NEXT_N(l1->node,i);
		      l3->pnode = l1->node;
		      l3->c = i;
		      l3->next = NULL;
		    }
		}
	    }
	  l2 = l1;
	  l1 = l1->next;
	  free (l2);
	}
    }
/*
for (i=0;i<=nc;i++) {
	printf("====================================\n");
	printf("nodo=%d\n",i);
	printf("suf=%d\n",trie(i).suffix_link);
	for(j=0;j<256;j++) {
		if (NEXT_N(i,j)) printf("%d---%c---->%d\n",i,j,NEXT_N(i,j));
	}{
		POSITION *p=trie(i).comp_pos;
		printf("Completas: ");
		while(p) {
			printf("%d,",p->pos);
			p=p->next;
		}
		printf("\n");
		p=trie(i).suf_pos;
		printf("Sufijos: ");
		while(p) {
			printf("%d,",p->pos);
			p=p->next;
		}
		printf("\n");
	}

}*/
}
int search_bmblocks_multi ()  
{
  register long i, ipatt, j, k, length, oldj, from;
  register int offset, pos, oldpos, l;
  int n, oldn;
  int m = PatternList.lmin;
  POSITION * p, paux;
  int type;
  char aux[100];
  int iaux,nx;
  BLK_SearchState BLK_State;
  TypeBlock *pblock,*pblock_j,*pblock_i;
  int shift;
  int brk;

  BLK_CleanState(&BLK_State);
  
  for (j = -1; j < FirstFree; j++) {
      pblock = get_block(j);
      pblock->length=0;
      pblock->ref=0;
      pblock->nlcount=0;
      pblock->c=j+1;
      pblock->type =0;
      pblock->node =0;
    }

  i = free_ent = FirstFree;
  pblock = get_block(i-1);
  pblock->c = oldj = getcode ();
  BLK_State.rpos++;
  if (oldj == -1)
    return (BLK_State.count);
  while (1)
    {
    readBlocks:
	while (BLK_State.rpos - BLK_State.tpos <= m) {
		printf("read i=%d\n",i);
	   if ((j = getcode ()) == -1) goto endText;
	  if (j == Clear) {
	      process_block_clear(i,&BLK_State);
	      free_ent = i = FirstFree - 1;
	      if ((j = getcode ()) == -1) goto endText;
	      pblock = get_block(i-1);
	      pblock->c = j;
	      oldj=i-1;
	  }
	  if (free_ent < maxmaxcode)
	    i = free_ent++;
	  else
	    i++;
	  pblock_j=get_block(oldj);
	  pblock=get_block(j-1);
	  pblock_i=get_block(i);
	  pblock_i->ref = oldj;
	  pblock_i->c = pblock->c;
	  pblock_i->length = pblock_j->length+1;
	  BLK_State.rpos += pblock_i->length;
	  
	  oldn = pblock_j->node;
	  type = pblock_j->type;
	  oldj = j;
         
	  printf("rpos=%d\n",BLK_State.rpos);
	printf("i=%d len=%d rpos=%d\n",i,pblock_i->length,BLK_State.rpos);
	 if (indPrintMatches) {
               pblock_i->nlcount = pblock_j->nlcount;
              if (pblock_i->c==NEWLINE)
                       pblock_i->nlcount++;
              BLK_State.nlrpos += pblock_i->nlcount;
         } else {
              if (pblock_j->nlcount)
                  pblock_i->nlcount = pblock_j->nlcount;
              else if (pblock_i->c==NEWLINE)
                  pblock_i->nlcount = pblock_i->length;
              else  pblock_i->nlcount = 0;
         }
	 /* If is a matched line */
	 if (BLK_State.nlaft)  {
	      brk=process_block_after_match(i,&BLK_State);
	      if (brk) goto endText;
	 }
	  
	  n = NEXT_N(oldn,pblock->c);
	  if (n > 0) {
	      if (type == 1) {		//sufijo
		  if (trie(n).es_prefijo)
		    {
		      pblock_i->node = n;
		      pblock_i->type = 1;
	              continue;
		    }
		} else {
		  pblock_i->node = n;
		  pblock_i->type = 0;
	          continue;
		}
	    }
	  n = oldn;
	  p = trie(n).suf_pos;
	  while (p != NULL && n > 0)
	    {
	      offset = trie(n).path_len - p->pos - 1;
	      for (k = 0; k < offset; k++)
		n = trie(n).suffix_link;
	        nx = NEXT_N(n,pblock->c);
	      if ((nx > 0) && (trie(nx).es_prefijo)) {
		  pblock_i->node = nx;
		  pblock_i->type = 1;
		  break;
	      }
	      p = trie(n).suf_pos;
	    }
	  if (p == NULL || n == 0)
	    {
	      pblock_i->node = 0;
	      pblock_i->type = 0;
	    }
	}
      
	
	/* now I've read one extra block. try to shift */ 
	j = i - 1;
	pblock = pblock_i;
      from = BLK_State.rpos - pblock_i->length;
      while (1) {
	  offset = from - 1 - BLK_State.tpos;
	  pblock = get_block(j);
	  printf("i=%d j=%d len_i=%d len_j=%d\n",i,j,pblock_i->length,pblock->length);
	  from -= pblock->length;
	  printf("offset=%d from=%d len=%d\n",offset,from,pblock->length);
	  if (offset < BLK_State.unchk) break;
	  n = pblock->node;
	  if (pblock->type == 0)
	    {/*completo */
	      p = trie(n).comp_pos;
	      while (p != NULL && (p->pos > offset))
		p = p->next;
	    }
	  else
	    {
	      p = NULL;
	    }
	  if (p == NULL)
	    {
	      if (trie(n).es_prefijo)
		{
		  p = &paux;
		  p->pos = trie(n).path_len - 1;
		  p->next = trie(n).suf_pos;
		}
	      else
		{
		  p = trie(n).suf_pos;
		}
	      while (p != NULL && (p->pos > offset))
		p = p->next;
	    }
	  if (p == NULL)
	    pos = 0;
	  
	  else
	    pos = p->pos;
	  
	  printf("1 At tpos=%d pos=%d off=%d\n",BLK_State.tpos,pos,offset);
	    if (pos < offset) shift=offset-pos;
	    else shift = 0;
	     if (shift > 0) {
	         if (BLK_State.unchk) {
	               if (BLK_State.unchk > shift)
	                      BLK_State.unchk-=shift;
	               else
	                      BLK_State.unchk = 0;
		 }
		 BLK_State.tpos += shift;
		 goto readBlocks;
	      }
	  j--;
	}
      
	/* only the last (i-th) block rests to be tested */ 
	j = i;
        from = BLK_State.rpos - pblock_i->length;
        length = pblock_i->length;
        offset = from - 1 - BLK_State.tpos - m;
	pblock = pblock_i;
        while (offset + length >= BLK_State.unchk) {
		pblock = get_block(pblock->ref);
	        length--;
	}
	//if (length <= BLK_State.unchk) goto report;
         offset = m - 1;
      n = pblock->node;
      if (pblock->type == 0)
	{			/*completo */
	  p = trie(n).comp_pos;
	  while (p != NULL && (p->pos > offset))
	    p = p->next;
	}
      else
	{
	  p = NULL;
	}
      if (p == NULL)
	{
	  if (pblock->type == 1 && trie(n).es_prefijo)
	    {
	      p = &paux;
	      p->pos = trie(n).path_len - 1;
	      p->next = trie(n).suf_pos;
	    }
	  else
	    {
	      p = trie(n).suf_pos;
	    }
	  while (p != NULL && (p->pos > offset))
	    p = p->next;
	}
      if (p == NULL)
	pos = 0;
      
      else
	pos = p->pos;
      
	  printf("2 At tpos=%d pos=%d off=%d\n",BLK_State.tpos,pos,offset);
	if (pos < offset) shift = offset-pos;
	else shift=0;
	if (shift > 0) {
	         if (BLK_State.unchk) {
	               if (BLK_State.unchk > shift)
	                      BLK_State.unchk-=shift;
	               else
	                      BLK_State.unchk = 0;
		 }
		 BLK_State.tpos += shift;
		 goto readBlocks;
	 }
      
	/* Verify the match */
report:
	/* Check uncheked text */
	if (BLK_State.unchk) {
		if (!check_oldbuf(&BLK_State)) {
			BLK_State.tpos++;
			BLK_State.unchk--;
			goto readBlocks;
		}
	}
	/* Check patterns longer than lmin */
        if (!check_residual_patterns(i,&BLK_State)) {
	            BLK_State.tpos++;
	            if (BLK_State.unchk) BLK_State.unchk--;
		    goto readBlocks;
        }

	 /* it passed all the tests, report the match */
	printf("Match at %d\n",BLK_State.tpos);
	    process_block_match(i,&BLK_State);

   }
endText:return (BLK_State.count);
}


