
#define ALPHABET 256

/*********************************************************/
/*   Construction du DAWG pour un ensemble de patterns   */
/*********************************************************/


/******************/
/*   Procedures   */
/******************/


/* remember de la table
 0 -> supleance
 1 -> Etat final ou non
 2 -> Longueur maximum
 3 -> clone ou pas
 4 -> longueur min
 5 -> etat Ac de la longueur min */





/*************************** gestion de la table directe **********************/


int * /* alocation dynamique de table */
allocation_dawg(int p_taille) {
  int * T;

  T= (int *)malloc((ALPHABET+6)*(p_taille)*sizeof(int));

  return T;
}

void /* initialisation de la table */
init_dawg_table(int * T, int taille) {
 int i;
  long int k;

   for(i=0;i<ALPHABET+6;i++) {
     for(k=0;k<taille;k++)
       T[k*(ALPHABET+6)+i]=-1;

     T[1]=1;   /* etat final en 0 !!! */
     T[2]=0;
   }
}



int /* donne la transition avant de l'etat par l'etiquette label*/
dawg_donne_transition_avant(int * T,int etat,int label) {
   return T[etat*(ALPHABET+6)+label+6];
}

int  /* construction d'une transition avant et arriere */
dawg_construit_simple_trans(int * T,int dep,int arr,int label) {
   T[dep*(ALPHABET+6)+label+6]=arr;  /* transition du depart */
}


int  /* ajout d'un noeud de l'automate */
dawg_cree_noeud(int * T,int *der, int supl,int final,int longueur) {
    int pos;

    pos = ++(*der);
    T[pos*(ALPHABET+6)]=supl;  /* fonction de supleance */
    T[pos*(ALPHABET+6)+1]=final;  /* etat final ou non */
    T[pos*(ALPHABET+6)+2]=longueur;   /* creation d'une longueur */
    T[pos*(ALPHABET+6)+3]=0;     /* non clone */
    return pos;
}

int /* donne le label de la transition du pere a l'etat par l'etiquette label*/
dawg_donne_longueur(int * T,int etat) {
   return T[etat*(ALPHABET+6)+2];
}

int /* donne la valeur de la fonction de supleance */
dawg_donne_supl(int * T,int noeud) {
  return T[noeud*(ALPHABET+6)];
}


void  /* modifie la fonction de supleance */
dawg_met_supl(int *T,int noeud,int val) {
  T[noeud*(ALPHABET+6)]=val;
}


void /* met l'ac a la valeur donnee */
dawg_met_ac(int *T,int noeud,int val) {
  T[noeud*(ALPHABET+6)+5]=val;
}


int     /* test si l'ac est deja mis */
dawg_existe_ac(int*T,int noeud) {
  return T[noeud*(ALPHABET+6)+5]!=-1;
}

int /* donne la valeur de la longeur min*/
dawg_donne_min(int * T,int noeud) {
  return T[noeud*(ALPHABET+6)+4];
}


void  /* modifie la longeur min */
dawg_met_long_min(int * T,int noeud,int val) {
  T[noeud*(ALPHABET+6)+4]=val;
}

void  /* modifie la longeur l'etat de AC de la long min */
dawg_met_AC_etat(int * T,int noeud,int val) {
  T[noeud*(ALPHABET+6)+5]=val;
}


int  /* prend l'etat AC correspondant au noeud */
dawg_donne_AC(int * T,int noeud) {
 return  T[noeud*(ALPHABET+6)+5];
}


int  /* test si un noeud est terminal 1 -> terninal, 0 sinon */
dawg_noeud_terminal(int * T,int x) {
 return (T[x*(ALPHABET+6)+1]);
}

int                            /* test d'existence d'une transition */
dawg_existe_transition(int * T,int w,int lettre) {
 return (T[w*(ALPHABET+6)+lettre+6]!=-1);
}




/*********************************************** ajout des lettres ********************************/


/*********** ajout d'une lettre simple lettres de base ********/



void     /* ajouter une lettre a l'automate et construire les transitions correspondantes niveau sup*/
dawg_update(int * T,int * der,int *activenode,int label) {
 int sink,w,v,newnode;
 int suiv,new_sink,q;
 int tamp;
 int sol;

 
 
 new_sink =dawg_cree_noeud(T,der,-1,-1,dawg_donne_longueur(T,*activenode)+1); /* nouveau noeud sink*/
                      /* construction d'une transition d'etiquette label du noeud actif au nouveau */
 dawg_construit_simple_trans(T,*activenode,new_sink,label);  

 sink = *activenode; /* sauvegarde de sink */
 *activenode = new_sink; /* transission du noeud actif */

 w = dawg_donne_supl(T,sink);        /* prise de l'etat de supleance de sink et mise ds w*/

 while ((w!=(-1)) && (!dawg_existe_transition(T,w,label))) {
   dawg_construit_simple_trans(T,w,new_sink,label);  /* construction d'uen transition simple */
     w = dawg_donne_supl(T,w);                        /* saut en supleance */
 }

 if (w==(-1)) {   /* ajout simple d'une fonction de supleance */
   dawg_met_supl(T,new_sink,0); /* l'etat est celui de depart */
 }
 else {   /* etape suivante de la construction */
     q = dawg_donne_transition_avant(T,w,label);

     dawg_met_supl(T,new_sink,q);

 }
}
