/*   The author of this code is Gonzalo Navarro, 1996.
     This code can be freely used and distributed for teaching and research
     purposes, provided it is not modified and this notice is kept attached.
     No part of this code can be used for direct or indirect commercial
     advantage without written permission of the author.
*/


#ifndef MULTIPATINCLUDED
#define MULTIPATINCLUDED


#include "basics.h"

	/* a fast multipattern search heuristic, based on bmhs.
	   the d table is computed as the worst among the
	   patterns (length = minimum among patterns). instead
	   of matching text against pattern, we search the
	   text into a trie of the patterns 
	*/

typedef int (*GAutom)[Sigma];

typedef struct 
   { GAutom T;			/* the trie of the patterns */
     int minlen,maxlen;		/* length of shorter pattern */
   } Multi;

	/* prepare to search patterns Ps[0]..Ps[r-1] */

void prepMulti (Multi *M, uchar **Ps, int r);

	/* free data */

void freeMulti (Multi *M);

	/* checks for a pattern starting at text */

int checkMulti (Multi *M, register uchar *text);

#endif
