/*   The author of this code is Gonzalo Navarro, 1996.
     This code can be freely used and distributed for teaching and research
     purposes, provided it is not modified and this notice is kept attached.
     No part of this code can be used for direct or indirect commercial
     advantage without written permission of the author.
*/


#include "multipat.h"
#include "makeg.c"

	/* prepare to search patterns Ps[0]..Ps[r-1] */

void prepMulti (Multi *M, uchar **Ps, int r)

  { int c,i,j,totlen;

	/* compute the total and minimum length */
    M->maxlen = M->minlen = totlen = strlen(Ps[0]);
    for (i=1;i<r;i++)
	{ int l = strlen(Ps[i]);
	  totlen += l;
	  if (l < M->minlen) M->minlen = l;
	  if (l > M->maxlen) M->maxlen = l;
	}
    
	/* compute the trie and automaton */
    M->T = MakeG (Ps,r,totlen);
  }

	/* free data */

void freeMulti (Multi *M)

   { free (M->T); M->T = NULL;
   }


int checkMulti (Multi *M, register uchar *text)

   { register GAutom T = M->T;
     register int state = 0;
     while (true)
        { state = T[state][*text++];
          if (state < 0) return -1;
          if (T[state][0] >= 0) return T[state][0];
        }
   } 

