/*   The author of this code is Gonzalo Navarro, 1996.
     This code can be freely used and distributed for teaching and research
     purposes, provided it is not modified and this notice is kept attached.
     No part of this code can be used for direct or indirect commercial
     advantage without written permission of the author.
*/



#ifndef CUTINCLUDED
#define CUTINCLUDED

#include "basics.h"

	/* cuts a pattern into subpatterns */

typedef struct
   { int *aclen;                /* accum lengths of Ps[0..i] */
     int *len;                  /* length of Ps[i] */
     uchar **ps;                /* subpatterns */
     int j;                     /* number of subpatterns */
     int k;                     /* k/j */
   } Cut;

void makeCut (uchar *pattern, int m, int k, int jj, Cut *cut);
static void add_to_pattern_list_aprox(char *str,int lenpat, int aclenpat);

void freeCut (Cut *cut);

#endif
